/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.container.state.MutableNavigationalState;
import org.apache.jetspeed.container.state.impl.NavigationalStateCodec;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalStates;
import org.apache.pluto.om.window.PortletWindow;

public abstract class AbstractNavigationalState
implements MutableNavigationalState {
    private NavigationalStateCodec codec;
    private PortletWindowRequestNavigationalStates requestStates;

    public AbstractNavigationalState(NavigationalStateCodec codec) {
        this.codec = codec;
    }

    public void init(String encodedState, String characterEncoding) throws UnsupportedEncodingException {
        if (this.requestStates == null) {
            this.requestStates = this.codec.decode(encodedState, characterEncoding);
        }
    }

    protected PortletWindowRequestNavigationalStates getPortletWindowRequestNavigationalStates() {
        return this.requestStates;
    }

    public void setState(PortletWindow window, WindowState windowState) {
        if (windowState != null) {
            String windowId = window.getId().toString();
            PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(windowId);
            if (!(state == null || state.getWindowState() != null && state.getWindowState().equals((Object)windowState))) {
                state.setWindowState(windowState);
            } else {
                state = new PortletWindowRequestNavigationalState(windowId);
                this.requestStates.addPortletWindowNavigationalState(windowId, state);
                state.setWindowState(windowState);
            }
        }
    }

    public void setMode(PortletWindow window, PortletMode portletMode) {
        if (portletMode != null) {
            String windowId = window.getId().toString();
            PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(windowId);
            if (!(state == null || state.getPortletMode() != null && state.getPortletMode().equals((Object)portletMode))) {
                state.setPortletMode(portletMode);
            } else {
                state = new PortletWindowRequestNavigationalState(windowId);
                this.requestStates.addPortletWindowNavigationalState(windowId, state);
                state.setPortletMode(portletMode);
            }
        }
    }

    public WindowState getState(String windowId) {
        WindowState windowState = null;
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(windowId);
        if (state != null) {
            windowState = state.getWindowState();
        }
        return windowState != null ? windowState : WindowState.NORMAL;
    }

    public WindowState getState(PortletWindow window) {
        return this.getState(window.getId().toString());
    }

    public PortletMode getMode(String windowId) {
        PortletMode portletMode = null;
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(windowId);
        if (state != null) {
            portletMode = state.getPortletMode();
        }
        return portletMode != null ? portletMode : PortletMode.VIEW;
    }

    public PortletMode getMode(PortletWindow window) {
        return this.getMode(window.getId().toString());
    }

    public PortletWindow getMaximizedWindow() {
        return this.requestStates.getMaximizedWindow();
    }

    public Iterator getParameterNames(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null && state.getParametersMap() != null) {
            return state.getParametersMap().keySet().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public String[] getParameterValues(PortletWindow window, String parameterName) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null && state.getParametersMap() != null) {
            return (String[])state.getParametersMap().get(parameterName);
        }
        return null;
    }

    public PortletWindow getPortletWindowOfAction() {
        return this.requestStates.getActionWindow();
    }

    public String encode(PortletWindow window, Map parameters, PortletMode mode, WindowState state, boolean action) throws UnsupportedEncodingException {
        return this.codec.encode(this.requestStates, window, parameters, mode, state, action, this.isNavigationalParameterStateFull(), this.isRenderParameterStateFull());
    }

    public String encode(PortletWindow window, PortletMode mode, WindowState state) throws UnsupportedEncodingException {
        return this.codec.encode(this.requestStates, window, mode, state, this.isNavigationalParameterStateFull(), this.isRenderParameterStateFull());
    }

    public Iterator getWindowIdIterator() {
        return this.requestStates.getWindowIdIterator();
    }
}

