/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.invoker;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.container.ContainerConstants;
import org.apache.jetspeed.container.invoker.JetspeedPortletInvoker;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletApplication;
import org.apache.jetspeed.request.RequestContext;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.servlet.WebApplicationDefinition;

public class ServletPortletInvoker
implements JetspeedPortletInvoker {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$container$invoker$ServletPortletInvoker == null ? (class$org$apache$jetspeed$container$invoker$ServletPortletInvoker = ServletPortletInvoker.class$("org.apache.jetspeed.container.invoker.ServletPortletInvoker")) : class$org$apache$jetspeed$container$invoker$ServletPortletInvoker));
    protected PortletFactory portletFactory;
    protected ServletContext jetspeedContext;
    protected ServletConfig jetspeedConfig;
    protected PortletDefinition portletDefinition;
    protected boolean activated = false;
    protected String servletMappingName;
    static /* synthetic */ Class class$org$apache$jetspeed$container$invoker$ServletPortletInvoker;

    public void passivate() {
        this.activated = false;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void activate(PortletFactory portletFactory, PortletDefinition portletDefinition, ServletConfig servletConfig) {
        this.portletFactory = portletFactory;
        this.jetspeedConfig = servletConfig;
        this.jetspeedContext = servletConfig.getServletContext();
        this.portletDefinition = portletDefinition;
        this.activated = true;
    }

    public void activate(PortletFactory portletFactory, PortletDefinition portletDefinition, ServletConfig servletConfig, String servletMappingName) {
        this.servletMappingName = servletMappingName;
        this.activate(portletFactory, portletDefinition, servletConfig);
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.invoke((PortletRequest)request, (PortletResponse)response, ContainerConstants.METHOD_RENDER);
    }

    public void action(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.invoke((PortletRequest)request, (PortletResponse)response, ContainerConstants.METHOD_ACTION);
    }

    public void load(PortletRequest request, RenderResponse response) throws PortletException {
        try {
            this.invoke(request, (PortletResponse)response, ContainerConstants.METHOD_NOOP);
        }
        catch (IOException e) {
            log.error((Object)"ServletPortletInvokerImpl.load() - Error while dispatching portlet.", (Throwable)e);
            throw new PortletException((Throwable)e);
        }
    }

    protected void invoke(PortletRequest portletRequest, PortletResponse portletResponse, Integer methodID) throws PortletException, IOException {
        ClassLoader paClassLoader = this.portletFactory.getPortletApplicationClassLoader((PortletApplication)this.portletDefinition.getPortletApplicationDefinition());
        MutablePortletApplication app = (MutablePortletApplication)this.portletDefinition.getPortletApplicationDefinition();
        WebApplicationDefinition webApplicationDefinition = app.getWebApplicationDefinition();
        if (webApplicationDefinition == null) {
            throw new IllegalStateException("Portlet application " + app.getName() + " has no associated web application.");
        }
        String portletApplicationName = webApplicationDefinition.getContextRoot();
        ServletRequest servletRequest = ((HttpServletRequestWrapper)((HttpServletRequestWrapper)((HttpServletRequestWrapper)portletRequest).getRequest()).getRequest()).getRequest();
        ServletResponse servletResponse = ((HttpServletResponseWrapper)portletResponse).getResponse();
        ServletContext appContext = this.jetspeedContext.getContext(portletApplicationName);
        if (null == appContext) {
            String message = "Failed to find Servlet context for Portlet Application: " + portletApplicationName;
            log.error((Object)message);
            throw new PortletException(message);
        }
        PortletInstance portletInstance = this.portletFactory.getPortletInstance(appContext, this.portletDefinition);
        RequestDispatcher dispatcher = appContext.getRequestDispatcher(this.servletMappingName);
        if (null == dispatcher) {
            String message = "Failed to get Request Dispatcher for Portlet Application: " + portletApplicationName + ", servlet: " + this.servletMappingName;
            log.error((Object)message);
            throw new PortletException(message);
        }
        try {
            try {
                servletRequest.setAttribute("org.apache.jetspeed.portlet", (Object)portletInstance);
                servletRequest.setAttribute("javax.portlet.config", (Object)portletInstance.getConfig());
                servletRequest.setAttribute("javax.portlet.request", (Object)portletRequest);
                servletRequest.setAttribute("javax.portlet.response", (Object)portletResponse);
                servletRequest.setAttribute("org.apache.jetspeed.method", (Object)methodID);
                RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
                servletRequest.setAttribute("org.apache.jetspeed.context", (Object)requestContext.getRequest().getContextPath());
                dispatcher.include(servletRequest, servletResponse);
            }
            catch (Exception e) {
                String message = "Failed to dispatch.include for Portlet Application: " + portletApplicationName + ", servlet: " + this.servletMappingName;
                log.error((Object)message, (Throwable)e);
                throw new PortletException(message, (Throwable)e);
            }
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            servletRequest.removeAttribute("org.apache.jetspeed.portlet");
            servletRequest.removeAttribute("javax.portlet.config");
            servletRequest.removeAttribute("javax.portlet.request");
            servletRequest.removeAttribute("javax.portlet.response");
            servletRequest.removeAttribute("org.apache.jetspeed.method");
            servletRequest.removeAttribute("org.apache.jetspeed.context");
            throw throwable;
        }
        servletRequest.removeAttribute("org.apache.jetspeed.portlet");
        servletRequest.removeAttribute("javax.portlet.config");
        servletRequest.removeAttribute("javax.portlet.request");
        servletRequest.removeAttribute("javax.portlet.response");
        servletRequest.removeAttribute("org.apache.jetspeed.method");
        servletRequest.removeAttribute("org.apache.jetspeed.context");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

