/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container;

import java.io.IOException;
import java.util.Properties;
import javax.portlet.PortletException;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.container.PortletContainerWrapper;
import org.apache.jetspeed.engine.servlet.ServletObjectAccess;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.PortletContainerEnvironment;

public class JetspeedPortletContainerWrapper
implements PortletContainerWrapper {
    private boolean initialized = false;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$container$JetspeedPortletContainerWrapper == null ? (class$org$apache$jetspeed$container$JetspeedPortletContainerWrapper = JetspeedPortletContainerWrapper.class$("org.apache.jetspeed.container.JetspeedPortletContainerWrapper")) : class$org$apache$jetspeed$container$JetspeedPortletContainerWrapper));
    private final PortletContainer pluto;
    private final String containerId;
    private final Properties properties;
    private final PortletContainerEnvironment environment;
    private final ServletConfig servletConfig;
    static /* synthetic */ Class class$org$apache$jetspeed$container$JetspeedPortletContainerWrapper;

    public JetspeedPortletContainerWrapper(PortletContainer pluto, String containerId, ServletConfig servletConfig, PortletContainerEnvironment env, Properties properties) {
        this.pluto = pluto;
        this.containerId = containerId;
        this.environment = env;
        this.properties = properties;
        this.servletConfig = servletConfig;
    }

    public JetspeedPortletContainerWrapper(PortletContainer pluto, String containerId, ServletConfig servletConfig, PortletContainerEnvironment env) {
        this(pluto, containerId, servletConfig, env, new Properties());
    }

    public void start() throws PortletContainerException {
        log.info((Object)"Attmepting to start Pluto portal container...");
        this.init(this.containerId, this.servletConfig, this.environment, this.properties);
        log.info((Object)"Pluto portlet container successfully started.");
    }

    public synchronized void init(String uniqueContainerId, ServletConfig servletConfig, PortletContainerEnvironment environment, Properties props) throws PortletContainerException {
        this.pluto.init(uniqueContainerId, servletConfig, environment, props);
        this.initialized = true;
    }

    public synchronized void shutdown() throws PortletContainerException {
        this.initialized = false;
        this.pluto.shutdown();
    }

    public void renderPortlet(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, IOException, PortletContainerException {
        if (portletWindow.getPortletEntity() == null) {
            log.warn((Object)("Could not render PortletWindow " + portletWindow.getId() + " as it has no PortletEntity defined."));
            return;
        }
        if (portletWindow.getPortletEntity().getPortletDefinition() == null) {
            log.warn((Object)("Could not render PortletWindow" + portletWindow.getId() + " as it has no PortletDefintion defined."));
            return;
        }
        this.pluto.renderPortlet(portletWindow, servletRequest, servletResponse);
    }

    public void processPortletAction(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, IOException, PortletContainerException {
        this.pluto.processPortletAction(portletWindow, servletRequest, servletResponse);
    }

    public void portletLoad(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, PortletContainerException {
        this.pluto.portletLoad(portletWindow, ServletObjectAccess.getServletRequest(servletRequest, portletWindow), ServletObjectAccess.getServletResponse(servletResponse, portletWindow));
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

