/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capabilities.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.capabilities.Capabilities;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.capabilities.MimeType;
import org.apache.jetspeed.capabilities.UnableToBuildCapabilityMapException;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.CapabilityValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;

public class CapabilityValveImpl
implements CapabilityValve {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$capabilities$impl$CapabilityValveImpl == null ? (class$org$apache$jetspeed$capabilities$impl$CapabilityValveImpl = CapabilityValveImpl.class$("org.apache.jetspeed.capabilities.impl.CapabilityValveImpl")) : class$org$apache$jetspeed$capabilities$impl$CapabilityValveImpl));
    String resourceDefault;
    private Capabilities capabilities;
    static /* synthetic */ Class class$org$apache$jetspeed$capabilities$impl$CapabilityValveImpl;

    public CapabilityValveImpl(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void initialize() throws PipelineException {
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        CapabilityMap cm;
        String requestMediaType = request.getRequestParameter("mediatype");
        String agent = request.getRequest().getHeader("User-Agent");
        try {
            cm = this.capabilities.getCapabilityMap(agent);
        }
        catch (UnableToBuildCapabilityMapException e) {
            throw new PipelineException("Falied to create capabilitied:  " + e.getMessage(), e);
        }
        MediaType mediaType = cm.getPreferredMediaType();
        MimeType mimeType = cm.getPreferredType();
        if (mediaType == null) {
            log.error((Object)"CapabilityMap returned a null media type");
            throw new PipelineException("CapabilityMap returned a null media type");
        }
        if (mimeType == null) {
            log.error((Object)"CapabilityMap returned a null mime type");
            throw new PipelineException("CapabilityMap returned a null mime type");
        }
        String encoding = request.getRequest().getCharacterEncoding();
        if (encoding == null && mediaType != null && mediaType.getCharacterSet() != null) {
            encoding = mediaType.getCharacterSet();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("MediaType: " + mediaType.getName()));
            log.debug((Object)("Encoding: " + encoding));
            log.debug((Object)("Mimetype: " + mimeType.getName()));
        }
        request.setCharacterEncoding(encoding);
        request.setCapabilityMap(cm);
        request.setMediaType(mediaType.getName());
        request.setMimeType(mimeType.getName());
        StringBuffer contentType = new StringBuffer(mimeType.getName());
        if (encoding != null) {
            contentType.append("; charset=" + encoding);
        }
        request.getResponse().setContentType(contentType.toString());
        context.invokeNext(request);
    }

    public String toString() {
        return "CapabilityValveImpl";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

