/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.ajax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AJAXRequest;

public class AJAXRequestImpl
implements AJAXRequest {
    public static final String AJAX_SERVICE = "ajax_service";
    public static final String AJAX_PARAM_PREFIX = "ajax_param_";
    private final HttpServletRequest request;
    private List ajaxParams;
    private final String serviceName;
    private final String methodName;
    private HttpServletResponse response;
    private ServletContext context;

    public AJAXRequestImpl(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws AJAXException {
        String split;
        this.request = request;
        this.response = response;
        this.context = context;
        String serviceRequest = request.getParameter(AJAX_SERVICE);
        if (serviceRequest == null) {
            throw new AJAXException("No 'ajax_service' parameter could be found in the request or it was not in the '{service_name}.{method_name}' format.");
        }
        this.serviceName = split = serviceRequest.split("\\.")[0];
        this.methodName = serviceRequest.split("\\.")[1];
        this.parseRequestArguments();
    }

    public List getParameters() {
        return this.ajaxParams;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    protected List parseRequestArguments() throws AJAXException {
        try {
            this.ajaxParams = new ArrayList();
            Map rawParams = this.request.getParameterMap();
            Iterator entryItr = rawParams.entrySet().iterator();
            while (entryItr.hasNext()) {
                Map.Entry entry = entryItr.next();
                String key = entry.getKey().toString();
                if (!key.startsWith(AJAX_PARAM_PREFIX)) continue;
                String[] paramInfo = key.split("_");
                int index = Integer.parseInt(paramInfo[2]);
                String type = paramInfo[3];
                AJAXParameter ajaxParam = new AJAXParameter(type, (String[])entry.getValue());
                this.ajaxParams.add(index, ajaxParam);
            }
            return this.ajaxParams;
        }
        catch (Throwable e) {
            throw new AJAXException("Errors were encountered parsing request parameters for the AJAX service " + this.serviceName + ": " + e.getMessage(), e);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    public HttpServletResponse getServletResponse() {
        return this.response;
    }

    public class AJAXParameter {
        private Object value;

        public AJAXParameter(String typeName, String[] paramValues) {
            if (typeName.equals("int")) {
                if (paramValues.length > 1) {
                    int[] intValues = new int[paramValues.length];
                    for (int i = 0; i < paramValues.length; ++i) {
                        intValues[i] = Integer.parseInt(paramValues[i]);
                    }
                } else {
                    this.value = new Integer(paramValues[0]);
                }
            } else if (typeName.equals("str")) {
                this.value = paramValues.length > 1 ? paramValues : paramValues[0];
            }
        }

        public Object getValue() {
            return this.value;
        }
    }
}

