/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.ajax;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AJAXRequest;
import org.apache.jetspeed.ajax.AJAXRequestImpl;
import org.apache.jetspeed.ajax.AJAXResponse;
import org.apache.jetspeed.ajax.AJAXService;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class AJAXFilter
implements Filter {
    private ApplicationContext ctx;
    private AJAXService ajaxService;
    private FilterConfig config;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain arg2) throws IOException, ServletException {
        try {
            response.setContentType("text/xml");
            if (this.ctx == null) {
                this.ctx = (ApplicationContext)this.config.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                this.ajaxService = (AJAXService)this.ctx.getBean("AJAXService");
            }
            AJAXRequestImpl ajaxRequest = new AJAXRequestImpl((HttpServletRequest)request, (HttpServletResponse)response, this.config.getServletContext());
            AJAXResponse ajaxReponse = this.ajaxService.processRequest((AJAXRequest)ajaxRequest);
            ajaxReponse.complete();
        }
        catch (AJAXException e) {
            ((HttpServletResponse)response).sendError(500, e.getMessage());
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }
}

