/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.aggregator.impl.RenderingJob;
import org.apache.jetspeed.aggregator.impl.Worker;
import org.apache.jetspeed.util.FIFOQueue;
import org.apache.jetspeed.util.Queue;

public class WorkerMonitor {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$aggregator$impl$WorkerMonitor == null ? (class$org$apache$jetspeed$aggregator$impl$WorkerMonitor = WorkerMonitor.class$("org.apache.jetspeed.aggregator.impl.WorkerMonitor")) : class$org$apache$jetspeed$aggregator$impl$WorkerMonitor));
    private static long sCount = 0L;
    private int minWorkers = 5;
    private int maxWorkers = 50;
    private int spareWorkers = 3;
    private int maxJobsPerWorker = 10;
    private Stack workers = new Stack();
    private ThreadGroup tg = new ThreadGroup("Workers");
    private Queue queue;
    static /* synthetic */ Class class$org$apache$jetspeed$aggregator$impl$WorkerMonitor;

    public void init() {
        this.addWorkers(this.minWorkers);
        this.setQueue((Queue)new FIFOQueue());
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    protected synchronized void addWorkers(int wCount) {
        int wCurrent = this.tg.activeCount();
        if (wCurrent < this.maxWorkers) {
            if (wCurrent + wCount > this.maxWorkers) {
                wCount = this.maxWorkers - wCurrent;
            }
            log.info((Object)("Creating " + wCount + " workers -> " + (wCurrent + wCount)));
            for (int i = 0; i < wCount; ++i) {
                Worker worker = new Worker(this, this.tg, "WORKER_" + ++sCount);
                worker.start();
                this.workers.push(worker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker getWorker() {
        Stack stack = this.workers;
        synchronized (stack) {
            if (this.workers.size() < this.spareWorkers) {
                this.addWorkers(this.spareWorkers);
            }
            if (this.workers.size() == 0) {
                return null;
            }
            return (Worker)this.workers.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RenderingJob job) {
        Worker worker = this.getWorker();
        AccessControlContext context = AccessController.getContext();
        if (worker == null) {
            this.queue.push((Object)job);
            this.queue.push((Object)context);
        } else {
            try {
                Worker worker2 = worker;
                synchronized (worker2) {
                    worker.setJob(job, context);
                    worker.notify();
                }
            }
            catch (Throwable t) {
                log.error((Object)"Worker exception", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Worker worker) {
        Object object = worker;
        synchronized (object) {
            if (worker.getJobCount() < this.maxJobsPerWorker && this.queue.size() > 0) {
                RenderingJob job = (RenderingJob)this.queue.pop();
                AccessControlContext context = (AccessControlContext)this.queue.pop();
                worker.setJob(job, context);
                return;
            }
            worker.setJob(null);
            worker.resetJobCount();
        }
        object = this.workers;
        synchronized (object) {
            this.workers.push(worker);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

