/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.security.AccessControlContext;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.aggregator.impl.RenderingJob;
import org.apache.jetspeed.aggregator.impl.WorkerMonitor;

public class Worker
extends Thread {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$aggregator$impl$Worker == null ? (class$org$apache$jetspeed$aggregator$impl$Worker = Worker.class$("org.apache.jetspeed.aggregator.impl.Worker")) : class$org$apache$jetspeed$aggregator$impl$Worker));
    private boolean running = true;
    private int jobCount = 0;
    private Runnable job = null;
    private AccessControlContext context = null;
    private WorkerMonitor monitor = null;
    static /* synthetic */ Class class$org$apache$jetspeed$aggregator$impl$Worker;

    public Worker(WorkerMonitor monitor) {
        this.setMonitor(monitor);
        this.setDaemon(true);
    }

    public Worker(WorkerMonitor monitor, ThreadGroup tg, String name) {
        super(tg, name);
        this.setMonitor(monitor);
        this.setDaemon(true);
    }

    public int getJobCount() {
        return this.jobCount;
    }

    public void resetJobCount() {
        this.jobCount = 0;
    }

    public void setRunning(boolean status) {
        this.running = status;
    }

    public void setMonitor(WorkerMonitor monitor) {
        this.monitor = monitor;
    }

    public void setJob(Runnable job, AccessControlContext context) {
        this.job = job;
        this.context = context;
    }

    public void setJob(Runnable job) {
        this.job = job;
        this.context = null;
    }

    public Runnable getJob() {
        return this.job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            Worker worker = this;
            synchronized (worker) {
                if (this.job == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (this.job != null) {
                log.debug((Object)("Processing job for window :" + ((RenderingJob)this.job).getWindow().getId()));
                Subject subject = null;
                if (this.context != null) {
                    subject = Subject.getSubject(this.context);
                }
                if (subject != null) {
                    Subject.doAsPrivileged(subject, new PrivilegedAction(){

                        public Object run() {
                            try {
                                Worker.this.job.run();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Thread error", t);
                            }
                            return null;
                        }
                    }, this.context);
                } else {
                    try {
                        this.job.run();
                    }
                    catch (Throwable t) {
                        log.error((Object)"Thread error", t);
                    }
                }
            }
            ++this.jobCount;
            this.monitor.release(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

