/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.aggregator.ContentDispatcher;
import org.apache.jetspeed.aggregator.ContentDispatcherCtrl;
import org.apache.jetspeed.aggregator.FailedToRenderFragmentException;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.aggregator.impl.ContentDispatcherImpl;
import org.apache.jetspeed.aggregator.impl.RenderingJob;
import org.apache.jetspeed.aggregator.impl.WorkerMonitor;
import org.apache.jetspeed.components.portletentity.PortletEntityNotStoredException;
import org.apache.jetspeed.container.window.FailedToRetrievePortletWindow;
import org.apache.jetspeed.container.window.PortletWindowAccessor;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.util.JetspeedObjectID;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.window.PortletWindow;

public class PortletRendererImpl
implements PortletRenderer {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$aggregator$impl$PortletRendererImpl == null ? (class$org$apache$jetspeed$aggregator$impl$PortletRendererImpl = PortletRendererImpl.class$("org.apache.jetspeed.aggregator.impl.PortletRendererImpl")) : class$org$apache$jetspeed$aggregator$impl$PortletRendererImpl));
    private WorkerMonitor monitor;
    private PortletContainer container;
    private PortletWindowAccessor windowAccessor;
    static /* synthetic */ Class class$org$apache$jetspeed$aggregator$impl$PortletRendererImpl;

    public PortletRendererImpl(PortletContainer container, PortletWindowAccessor windowAccessor) {
        this.container = container;
        this.windowAccessor = windowAccessor;
    }

    public void start() {
        this.monitor = new WorkerMonitor();
        this.monitor.init();
    }

    public void stop() {
    }

    public void renderNow(ContentFragment fragment, RequestContext requestContext) {
        HttpServletRequest servletRequest = null;
        HttpServletResponse servletResponse = null;
        ContentDispatcher dispatcher = null;
        PortletWindow portletWindow = null;
        try {
            portletWindow = this.getPortletWindow(fragment);
            ContentDispatcherCtrl dispatcherCtrl = this.getDispatcherCtrl(requestContext, true);
            dispatcher = this.getDispatcher(requestContext, true);
            servletRequest = requestContext.getRequestForWindow(portletWindow);
            servletResponse = dispatcherCtrl.getResponseForWindow(portletWindow, requestContext);
            RenderingJob rJob = this.buildRenderingJob(fragment, servletRequest, servletResponse, requestContext);
            rJob.execute();
        }
        catch (Exception e) {
            fragment.overrideRenderedContent(e.toString());
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void renderNow(ContentFragment fragment, HttpServletRequest request, HttpServletResponse response) {
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        ContentDispatcher dispatcher = this.getDispatcher(requestContext, true);
        PortletWindow portletWindow = null;
        try {
            portletWindow = this.getPortletWindow(fragment);
            ContentDispatcherCtrl dispatcherCtrl = this.getDispatcherCtrl(requestContext, true);
            HttpServletRequest servletRequest = requestContext.getRequestForWindow(portletWindow);
            HttpServletResponse servletResponse = dispatcherCtrl.getResponseForWindow(portletWindow, requestContext);
            RenderingJob rJob = this.buildRenderingJob(fragment, servletRequest, servletResponse, requestContext);
            rJob.execute();
        }
        catch (Exception e) {
            fragment.overrideRenderedContent(e.toString());
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void render(ContentFragment fragment, RequestContext requestContext) {
        ContentDispatcherCtrl dispatcherCtrl = this.getDispatcherCtrl(requestContext, true);
        ContentDispatcher dispatcher = this.getDispatcher(requestContext, true);
        HttpServletRequest servletRequest = null;
        HttpServletResponse servletResponse = null;
        try {
            PortletWindow portletWindow = this.getPortletWindow(fragment);
            servletRequest = requestContext.getRequestForWindow(portletWindow);
            servletResponse = dispatcherCtrl.getResponseForWindow(portletWindow, requestContext);
            RenderingJob rJob = this.buildRenderingJob(fragment, servletRequest, servletResponse, requestContext);
            this.monitor.process(rJob);
        }
        catch (Exception e1) {
            servletRequest = requestContext.getRequest();
            servletResponse = dispatcherCtrl.getResponseForFragment((Fragment)fragment, requestContext);
            log.error((Object)("render() failed: " + e1.toString()), (Throwable)e1);
            fragment.overrideRenderedContent(e1.toString());
        }
    }

    public ContentDispatcher getDispatcher(RequestContext request, boolean isParallel) {
        return (ContentDispatcher)this.getDispatcherCtrl(request, isParallel);
    }

    protected ContentDispatcherCtrl getDispatcherCtrl(RequestContext request, boolean isParallel) {
        if (request.getContentDispatcher() == null) {
            request.setContentDispatcher((ContentDispatcher)new ContentDispatcherImpl(isParallel));
        }
        return (ContentDispatcherCtrl)request.getContentDispatcher();
    }

    protected PortletWindow getPortletWindow(ContentFragment fragment) throws FailedToRetrievePortletWindow, PortletEntityNotStoredException {
        JetspeedObjectID oid = JetspeedObjectID.createFromString((String)fragment.getId());
        PortletWindow portletWindow = this.windowAccessor.getPortletWindow(fragment);
        if (portletWindow == null) {
            throw new FailedToRetrievePortletWindow("Portlet Window creation failed for fragment: " + fragment.getId() + ", " + fragment.getName());
        }
        PortletEntity portletEntity = portletWindow.getPortletEntity();
        return portletWindow;
    }

    protected RenderingJob buildRenderingJob(ContentFragment fragment, HttpServletRequest request, HttpServletResponse response, RequestContext requestContext) throws FailedToRetrievePortletWindow, FailedToRenderFragmentException, PortletEntityNotStoredException {
        ContentDispatcher dispatcher = null;
        PortletWindow portletWindow = this.getPortletWindow(fragment);
        ContentDispatcherCtrl dispatcherCtrl = this.getDispatcherCtrl(requestContext, true);
        dispatcher = this.getDispatcher(requestContext, true);
        request = requestContext.getRequestForWindow(portletWindow);
        response = dispatcherCtrl.getResponseForWindow(portletWindow, requestContext);
        request.setAttribute("org.apache.jetspeed.Page", (Object)requestContext.getPage());
        request.setAttribute("org.apache.jetspeed.Fragment", (Object)fragment);
        request.setAttribute("org.apache.jetspeed.ContentDispatcher", (Object)dispatcher);
        request.setAttribute("org.apache.jetspeed.request.RequestContext", (Object)requestContext);
        request.setAttribute("org.apache.jetspeed.Fragment", (Object)fragment);
        PortletContent portletContent = dispatcher.getPortletContent((Fragment)fragment);
        fragment.setPortletContent(portletContent);
        return new RenderingJob(this.container, portletContent, fragment, request, response, requestContext, portletWindow);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

