/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.aggregator.ContentDispatcher;
import org.apache.jetspeed.aggregator.FailedToRenderFragmentException;
import org.apache.jetspeed.aggregator.PageAggregator;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.headerresource.HeaderResource;
import org.apache.jetspeed.headerresource.HeaderResourceFactory;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.apache.pluto.om.window.PortletWindow;

public class PageAggregatorImpl
implements PageAggregator {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$aggregator$impl$PageAggregatorImpl == null ? (class$org$apache$jetspeed$aggregator$impl$PageAggregatorImpl = PageAggregatorImpl.class$("org.apache.jetspeed.aggregator.impl.PageAggregatorImpl")) : class$org$apache$jetspeed$aggregator$impl$PageAggregatorImpl));
    public static final int STRATEGY_SEQUENTIAL = 0;
    public static final int STRATEGY_PARALLEL = 1;
    private int strategy = 0;
    private PortletRenderer renderer;
    private List fallBackContentPathes;
    static /* synthetic */ Class class$org$apache$jetspeed$aggregator$impl$PageAggregatorImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$headerresource$HeaderResourceFactory;

    public PageAggregatorImpl(PortletRenderer renderer, int strategy, List fallBackContentPathes) {
        this.renderer = renderer;
        this.strategy = strategy;
        this.fallBackContentPathes = fallBackContentPathes;
    }

    public PageAggregatorImpl(PortletRenderer renderer, List fallBackContentPathes) {
        this(renderer, 0, fallBackContentPathes);
    }

    public void build(RequestContext context) throws JetspeedException, IOException {
        ContentPage page = context.getPage();
        if (null == page) {
            throw new JetspeedException("Failed to find PSML Pin ContentPageAggregator.build");
        }
        ContentFragment root = page.getRootContentFragment();
        if (root == null) {
            throw new JetspeedException("No root ContentFragment found in ContentPage");
        }
        String layoutDecorator = root.getDecorator();
        if (layoutDecorator == null) {
            layoutDecorator = page.getDefaultDecorator(root.getType());
        }
        String defaultPortletDecorator = page.getDefaultDecorator("portlet");
        ArrayList<String> contentPathes = (ArrayList<String>)context.getSessionAttribute("org.apache.jetspeed.content.pathes");
        if (contentPathes == null) {
            contentPathes = new ArrayList<String>(2);
            context.setSessionAttribute("org.apache.jetspeed.content.pathes", contentPathes);
        }
        String mediaType = context.getCapabilityMap().getPreferredMediaType().getName();
        if (contentPathes.size() < 1) {
            contentPathes.add(root.getType() + "/" + mediaType + "/" + layoutDecorator);
            contentPathes.add("portlet/" + mediaType + "/" + defaultPortletDecorator);
            Iterator defaults = this.fallBackContentPathes.iterator();
            while (defaults.hasNext()) {
                String path = (String)defaults.next();
                contentPathes.add(path.replaceAll("\\{mediaType\\}", mediaType));
            }
        } else {
            contentPathes.set(0, root.getType() + "/" + mediaType + "/" + layoutDecorator);
            contentPathes.set(1, "portlet/" + mediaType + "/" + defaultPortletDecorator);
        }
        if (layoutDecorator != null) {
            this.addStyle(context, layoutDecorator, "layout");
        }
        ContentDispatcher dispatcher = this.renderer.getDispatcher(context, this.strategy == 1);
        NavigationalState nav = context.getPortalURL().getNavigationalState();
        PortletWindow window = nav.getMaximizedWindow();
        if (null != window) {
            this.renderMaximizedWindow(context, page, root, window);
        } else {
            this.aggregateAndRender(root, context, page);
        }
        context.getResponse().getWriter().write(root.getRenderedContent());
        if (null != window) {
            context.getRequest().removeAttribute("org.apache.jetspeed.maximized.Fragment");
            context.getRequest().removeAttribute("org.apache.jetspeed.maximized.Layout");
        }
    }

    protected void renderMaximizedWindow(RequestContext context, ContentPage page, ContentFragment layoutContentFragment, PortletWindow window) throws FailedToRenderFragmentException {
        String defaultPortletDecorator = page.getDefaultDecorator("portlet");
        ContentFragment maxedContentFragment = page.getContentFragmentById(window.getId().toString());
        if (maxedContentFragment != null) {
            context.getRequest().setAttribute("org.apache.jetspeed.maximized.Fragment", (Object)maxedContentFragment);
            context.getRequest().setAttribute("org.apache.jetspeed.Fragment", (Object)maxedContentFragment);
            context.getRequest().setAttribute("org.apache.jetspeed.maximized.Layout", (Object)page.getRootContentFragment());
            if (maxedContentFragment.getDecorator() != null) {
                log.debug((Object)("decorator=" + layoutContentFragment.getDecorator()));
                this.addStyle(context, maxedContentFragment.getDecorator(), "portlet");
            } else {
                log.debug((Object)("no decorator for defined for portlet fragement," + layoutContentFragment.getId() + ".  So using page default, " + defaultPortletDecorator));
                this.addStyle(context, defaultPortletDecorator, "portlet");
            }
            try {
                this.renderer.renderNow(maxedContentFragment, context);
                this.renderer.renderNow(layoutContentFragment, context);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                maxedContentFragment.overrideRenderedContent("Sorry, but we were unable access the requested portlet.  Send the following message to your portal admin:  " + e.getMessage());
            }
        }
    }

    private void addStyle(RequestContext context, String decoratorName, String decoratorType) {
        HeaderResourceFactory headerResourceFactory = (HeaderResourceFactory)Jetspeed.getComponentManager().getComponent((Object)(class$org$apache$jetspeed$headerresource$HeaderResourceFactory == null ? (class$org$apache$jetspeed$headerresource$HeaderResourceFactory = PageAggregatorImpl.class$("org.apache.jetspeed.headerresource.HeaderResourceFactory")) : class$org$apache$jetspeed$headerresource$HeaderResourceFactory));
        HeaderResource headerResource = headerResourceFactory.getHeaderResouce(context);
        if (decoratorType.equals("layout")) {
            headerResource.addStyleSheet("content/css/styles.css");
        } else {
            headerResource.addStyleSheet("content/" + decoratorName + "/css/styles.css");
        }
    }

    protected void aggregateAndRender(ContentFragment f, RequestContext context, ContentPage page) throws FailedToRenderFragmentException {
        if (f.getContentFragments() != null && f.getContentFragments().size() > 0) {
            Iterator children = f.getContentFragments().iterator();
            while (children.hasNext()) {
                ContentFragment child = (ContentFragment)children.next();
                if ("hidden".equals(f.getState())) continue;
                this.aggregateAndRender(child, context, page);
            }
        }
        String defaultPortletDecorator = page.getDefaultDecorator("portlet");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rendering portlet fragment: [[name, " + f.getName() + "], [id, " + f.getId() + "]]"));
        }
        if (this.strategy == 0) {
            this.renderer.renderNow(f, context);
        } else {
            this.renderer.render(f, context);
        }
        if (f.getDecorator() != null && f.getType().equals("portlet")) {
            log.debug((Object)("decorator=" + f.getDecorator()));
            this.addStyle(context, f.getDecorator(), "portlet");
        } else if (f.getDecorator() == null && f.getType().equals("portlet")) {
            log.debug((Object)("no decorator for defined for portlet fragement," + f.getId() + ".  So using page default, " + defaultPortletDecorator));
            this.addStyle(context, defaultPortletDecorator, "portlet");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

