/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.aggregator.Aggregator;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.container.window.PortletWindowAccessor;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.om.window.PortletWindow;

public class BasicAggregator
implements Aggregator {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$aggregator$impl$BasicAggregator == null ? (class$org$apache$jetspeed$aggregator$impl$BasicAggregator = BasicAggregator.class$("org.apache.jetspeed.aggregator.impl.BasicAggregator")) : class$org$apache$jetspeed$aggregator$impl$BasicAggregator));
    public static final int STRATEGY_SEQUENTIAL = 0;
    public static final int STRATEGY_PARALLEL = 1;
    private int strategy = 0;
    private PortletRegistry registry;
    private PortletWindowAccessor windowAccessor;
    private PortletContainer portletContainer;
    static /* synthetic */ Class class$org$apache$jetspeed$aggregator$impl$BasicAggregator;

    public BasicAggregator(PortletRegistry registry, PortletWindowAccessor windowAccessor, PortletContainer portletContainer, int strategy) {
        this.registry = registry;
        this.windowAccessor = windowAccessor;
        this.strategy = strategy;
        this.portletContainer = portletContainer;
    }

    public BasicAggregator(PortletRegistry registry, PortletWindowAccessor windowAccessor, PortletContainer portletContainer) {
        this(registry, windowAccessor, portletContainer, 0);
    }

    public void start() {
    }

    public void stop() {
    }

    public void build(RequestContext request) throws JetspeedException {
        ContentPage page = request.getPage();
        if (null == page) {
            throw new JetspeedException("Failed to find PSML Pin BasicAggregator.build");
        }
        ContentFragment root = page.getRootContentFragment();
        this.render(this.portletContainer, root, request);
        Iterator fit = root.getFragments().iterator();
        while (fit.hasNext()) {
            ContentFragment fragment = (ContentFragment)fit.next();
            if (fragment.getType().equals("layout")) {
                // empty if block
            }
            this.render(this.portletContainer, fragment, request);
        }
    }

    private void render(PortletContainer container, ContentFragment fragment, RequestContext request) {
        try {
            System.out.println("*** Getting portlet from registry: " + fragment.getName());
            PortletDefinitionComposite portletDefinition = this.registry.getPortletDefinitionByUniqueName(fragment.getName());
            if (portletDefinition == null) {
                throw new JetspeedException("Failed to load: " + fragment.getName() + " from registry");
            }
            PortletWindow portletWindow = this.windowAccessor.getPortletWindow(fragment);
            HttpServletRequest servletRequest = request.getRequestForWindow(portletWindow);
            HttpServletResponse servletResponse = request.getResponseForWindow(portletWindow);
            container.renderPortlet(portletWindow, servletRequest, servletResponse);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("Failed to service portlet, portlet exception: " + t));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

