/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.configuration.Configuration;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.engine.Engine;
import org.apache.pluto.util.Enumerator;

public class JetspeedPortalContext
implements PortalContext {
    private static final String SUPPORTED_WINDOWSTATE_ATTR = "supported.windowstate";
    private static final String SUPPORTED_PORTLETMODE_ATTR = "supported.portletmode";
    private static final String PORTAL_VERSION_ATTR = "portal.version";
    private static final String PORTAL_NAME_ATTR = "portal.name";
    private Engine engine = null;
    private HashMap attributes = new HashMap();
    private Configuration configuration = null;
    private String applicationRoot;
    private final List portletModes;
    private final List windowStates;
    private final String portalName;
    private final String portalVersion;

    public JetspeedPortalContext(Engine engine, Configuration configuration, String applicationRoot) {
        this.engine = engine;
        this.configuration = configuration;
        this.applicationRoot = applicationRoot;
        this.portalName = configuration.getString(PORTAL_NAME_ATTR);
        this.portalVersion = configuration.getString(PORTAL_VERSION_ATTR);
        String[] supportedModes = configuration.getStringArray(SUPPORTED_PORTLETMODE_ATTR);
        this.portletModes = new ArrayList(supportedModes.length);
        for (int i = 0; i < supportedModes.length; ++i) {
            this.portletModes.add(new PortletMode(supportedModes[i].toString().toLowerCase()));
        }
        String[] supportedStates = configuration.getStringArray(SUPPORTED_WINDOWSTATE_ATTR);
        this.windowStates = new ArrayList(supportedStates.length);
        for (int i = 0; i < supportedStates.length; ++i) {
            this.windowStates.add(new WindowState(supportedStates[i].toString().toLowerCase()));
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getConfigurationProperty(String key) {
        return this.configuration.getString(key);
    }

    public String getConfigurationProperty(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getApplicationRoot() {
        return this.applicationRoot;
    }

    public void setApplicationRoot(String applicationRoot) {
        this.applicationRoot = applicationRoot;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        return (String)this.configuration.getProperty(name);
    }

    public Enumeration getPropertyNames() {
        return new Enumerator(this.configuration.getKeys());
    }

    public Enumeration getSupportedPortletModes() {
        return new Enumerator((Collection)this.portletModes);
    }

    public Enumeration getSupportedWindowStates() {
        return new Enumerator((Collection)this.windowStates);
    }

    public String getPortalInfo() {
        return this.portalName + "/" + this.portalVersion;
    }
}

