/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDaoImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserPrincipalDao;

public class LdapUserPrincipalDaoImpl
extends LdapPrincipalDaoImpl
implements LdapUserPrincipalDao {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$spi$impl$ldap$LdapUserPrincipalDaoImpl == null ? (class$org$apache$jetspeed$security$spi$impl$ldap$LdapUserPrincipalDaoImpl = LdapUserPrincipalDaoImpl.class$("org.apache.jetspeed.security.spi.impl.ldap.LdapUserPrincipalDaoImpl")) : class$org$apache$jetspeed$security$spi$impl$ldap$LdapUserPrincipalDaoImpl));
    private static final String GROUP_ATTR_NAME = "j2-group";
    static /* synthetic */ Class class$org$apache$jetspeed$security$spi$impl$ldap$LdapUserPrincipalDaoImpl;

    public LdapUserPrincipalDaoImpl() throws NamingException, SecurityException {
    }

    public LdapUserPrincipalDaoImpl(String ldapServerName, String rootDn, String rootPassword, String rootContext, String defaultDnSuffix) throws NamingException, SecurityException {
        super(ldapServerName, rootDn, rootPassword, rootContext, defaultDnSuffix);
    }

    public void addGroup(String userPrincipalUid, String groupPrincipalUid) throws SecurityException {
        this.modifyUserGroup(userPrincipalUid, groupPrincipalUid, 1);
    }

    private void modifyUserGroup(String userPrincipalUid, String groupPrincipalUid, int operationType) throws SecurityException {
        this.validateUid(userPrincipalUid);
        this.validateUid(groupPrincipalUid);
        String userDn = this.lookupByUid(userPrincipalUid);
        try {
            String rdn = this.getSubcontextName(userDn);
            BasicAttributes attrs = new BasicAttributes(false);
            attrs.put(GROUP_ATTR_NAME, groupPrincipalUid);
            this.ctx.modifyAttributes(rdn, operationType, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public void removeGroup(String userPrincipalUid, String groupPrincipalUid) throws SecurityException {
        this.modifyUserGroup(userPrincipalUid, groupPrincipalUid, 3);
    }

    protected Attributes defineLdapAttributes(String principalUid) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute classes = new BasicAttribute("objectclass");
        classes.add("top");
        classes.add("person");
        classes.add("uidObject");
        classes.add("organizationalPerson");
        classes.add("inetorgperson");
        classes.add("jetspeed-2-user");
        attrs.put(classes);
        attrs.put("cn", principalUid);
        attrs.put("uid", principalUid);
        attrs.put("sn", principalUid);
        return attrs;
    }

    protected Principal makePrincipal(String principalUid) {
        return new UserPrincipalImpl(principalUid);
    }

    protected String getObjectClass() {
        return "jetspeed-2-user";
    }

    public String[] getUserUidsForGroup(String groupPrincipalUid) throws SecurityException {
        this.validateUid(groupPrincipalUid);
        SearchControls cons = this.setSearchControls();
        try {
            LOG.debug((Object)"1");
            ArrayList userPrincipalUids = new ArrayList();
            NamingEnumeration results = this.searchUserByGroup(groupPrincipalUid, cons);
            LOG.debug((Object)"2");
            while (results.hasMore()) {
                LOG.debug((Object)"3");
                SearchResult result = (SearchResult)results.next();
                Attributes answer = result.getAttributes();
                userPrincipalUids.addAll(this.getAttributes(this.getAttribute("uid", answer)));
            }
            return userPrincipalUids.toArray(new String[userPrincipalUids.size()]);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private NamingEnumeration searchUserByGroup(String groupPrincipalUid, SearchControls cons) throws NamingException {
        String query = "(&(j2-group=" + groupPrincipalUid + ") (objectclass=" + this.getObjectClass() + "))";
        LOG.debug((Object)("query[" + query + "]"));
        NamingEnumeration<SearchResult> searchResults = this.ctx.search("", "(&(j2-group=" + groupPrincipalUid + ") (objectclass=" + this.getObjectClass() + "))", cons);
        return searchResults;
    }

    public String[] getGroupUidsForUser(String userPrincipalUid) throws SecurityException {
        this.validateUid(userPrincipalUid);
        SearchControls cons = this.setSearchControls();
        try {
            NamingEnumeration results = this.searchByWildcardedUid(userPrincipalUid, cons);
            return this.getGroups(results, userPrincipalUid);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private String[] getGroups(NamingEnumeration results, String uid) throws NamingException {
        if (!results.hasMore()) {
            throw new NamingException("Could not find any user with uid[" + uid + "]");
        }
        Attributes userAttributes = this.getFirstUser(results);
        List uids = this.getAttributes(this.getAttribute(GROUP_ATTR_NAME, userAttributes));
        return uids.toArray(new String[uids.size()]);
    }

    private Attributes getFirstUser(NamingEnumeration results) throws NamingException {
        SearchResult result = (SearchResult)results.next();
        Attributes answer = result.getAttributes();
        return answer;
    }

    private List getAttributes(Attribute attr) throws NamingException {
        ArrayList uids = new ArrayList();
        if (attr != null) {
            NamingEnumeration<?> groupUidEnum = attr.getAll();
            while (groupUidEnum.hasMoreElements()) {
                uids.add(groupUidEnum.nextElement());
            }
        }
        return uids;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

