/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.spi.UserSecurityHandler;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserPrincipalDaoImpl;

public class LdapUserSecurityHandler
implements UserSecurityHandler {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$spi$impl$LdapUserSecurityHandler == null ? (class$org$apache$jetspeed$security$spi$impl$LdapUserSecurityHandler = LdapUserSecurityHandler.class$("org.apache.jetspeed.security.spi.impl.LdapUserSecurityHandler")) : class$org$apache$jetspeed$security$spi$impl$LdapUserSecurityHandler));
    private LdapPrincipalDao ldap;
    static /* synthetic */ Class class$org$apache$jetspeed$security$spi$impl$LdapUserSecurityHandler;

    public LdapUserSecurityHandler(LdapPrincipalDao ldap) {
        this.ldap = ldap;
    }

    public LdapUserSecurityHandler() throws NamingException, SecurityException {
        this(new LdapUserPrincipalDaoImpl());
    }

    public boolean isUserPrincipal(String uid) {
        this.verifyUid(uid);
        return this.getUserPrincipal(uid) != null;
    }

    public Principal getUserPrincipal(String uid) {
        this.verifyUid(uid);
        try {
            String dn = this.ldap.lookupByUid(uid);
            if (!StringUtils.isEmpty((String)dn)) {
                return new UserPrincipalImpl(uid);
            }
        }
        catch (SecurityException e) {
            this.logSecurityException(e, uid);
        }
        return null;
    }

    private void verifyUid(String uid) {
        if (StringUtils.isEmpty((String)uid)) {
            throw new IllegalArgumentException("The uid cannot be null or empty.");
        }
    }

    private void logSecurityException(SecurityException se, String uid) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("An LDAP error has occurred for user uid:" + uid), (Throwable)se);
        }
    }

    public List getUserPrincipals(String filter) {
        try {
            return Arrays.asList(this.ldap.find(filter));
        }
        catch (SecurityException e) {
            this.logSecurityException(e, filter);
            return new ArrayList();
        }
    }

    public void addUserPrincipal(UserPrincipal userPrincipal) throws SecurityException {
        this.verifyUserPrincipal(userPrincipal);
        String uid = userPrincipal.getName();
        if (this.isUserPrincipal(uid)) {
            throw new SecurityException(SecurityException.USER_ALREADY_EXISTS.create((Object)uid));
        }
        this.ldap.create(uid);
    }

    public void updateUserPrincipal(UserPrincipal userPrincipal) throws SecurityException {
        this.verifyUserPrincipal(userPrincipal);
        String uid = userPrincipal.getName();
        if (!this.isUserPrincipal(uid)) {
            this.ldap.create(uid);
        }
    }

    private void verifyUserPrincipal(UserPrincipal userPrincipal) {
        if (userPrincipal == null) {
            throw new IllegalArgumentException("The UserPrincipal cannot be null or empty.");
        }
    }

    public void removeUserPrincipal(UserPrincipal userPrincipal) throws SecurityException {
        this.verifyUserPrincipal(userPrincipal);
        String uid = userPrincipal.getName();
        this.ldap.delete(uid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

