/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.Collection;
import java.util.Date;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.spi.PasswordCredentialProvider;
import org.apache.jetspeed.security.spi.impl.DefaultInternalPasswordCredentialInterceptor;

public class InternalPasswordCredentialStateHandlingInterceptor
extends DefaultInternalPasswordCredentialInterceptor {
    private int maxNumberOfAuthenticationFailures;
    private long maxLifeSpanInMillis;

    public InternalPasswordCredentialStateHandlingInterceptor(int maxNumberOfAuthenticationFailures, int maxLifeSpanInDays) {
        this.maxNumberOfAuthenticationFailures = maxNumberOfAuthenticationFailures;
        this.maxLifeSpanInMillis = (long)maxLifeSpanInDays * 1000L * 60L * 60L * 24L;
    }

    public boolean afterAuthenticated(InternalUserPrincipal internalUser, String userName, InternalCredential credential, boolean authenticated) throws SecurityException {
        boolean update = super.afterAuthenticated(internalUser, userName, credential, authenticated);
        if (!credential.isExpired()) {
            long currentTime;
            long expirationTime = credential.getExpirationDate().getTime();
            if (expirationTime <= (currentTime = new Date().getTime())) {
                credential.setExpired(true);
                update = true;
            } else if (!authenticated && this.maxNumberOfAuthenticationFailures > 0) {
                int authenticationFailures = credential.getAuthenticationFailures() + 1;
                credential.setAuthenticationFailures(authenticationFailures);
                if (authenticationFailures >= this.maxNumberOfAuthenticationFailures) {
                    credential.setEnabled(false);
                }
                update = true;
            }
        }
        return update;
    }

    public boolean afterLoad(PasswordCredentialProvider pcProvider, String userName, InternalCredential credential) throws SecurityException {
        boolean update = super.afterLoad(pcProvider, userName, credential);
        if (credential.getExpirationDate() == null) {
            credential.setExpirationDate(new java.sql.Date(new Date().getTime() + this.maxLifeSpanInMillis));
            update = true;
        }
        if (!credential.isUpdateRequired() && credential.getLastAuthenticationDate() == null && credential.getPreviousAuthenticationDate() == null) {
            credential.setUpdateRequired(true);
            update = true;
        }
        return update;
    }

    public void beforeCreate(InternalUserPrincipal internalUser, Collection credentials, String userName, InternalCredential credential, String password) throws SecurityException {
        super.beforeCreate(internalUser, credentials, userName, credential, password);
        credential.setExpirationDate(new java.sql.Date(new Date().getTime() + this.maxLifeSpanInMillis));
        credential.setExpired(false);
        credential.setAuthenticationFailures(0);
    }

    public void beforeSetPassword(InternalUserPrincipal internalUser, Collection credentials, String userName, InternalCredential credential, String password, boolean authenticated) throws SecurityException {
        super.beforeSetPassword(internalUser, credentials, userName, credential, password, authenticated);
        credential.setExpirationDate(new java.sql.Date(new Date().getTime() + this.maxLifeSpanInMillis));
        credential.setExpired(false);
        credential.setAuthenticationFailures(0);
        credential.setUpdateRequired(false);
    }
}

