/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Principal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;
import org.apache.jetspeed.security.om.InternalRolePrincipal;
import org.apache.jetspeed.security.om.impl.InternalRolePrincipalImpl;
import org.apache.jetspeed.security.spi.RoleSecurityHandler;
import org.apache.jetspeed.security.spi.SecurityAccess;

public class DefaultRoleSecurityHandler
implements RoleSecurityHandler {
    private SecurityAccess commonQueries = null;

    public DefaultRoleSecurityHandler(SecurityAccess commonQueries) {
        this.commonQueries = commonQueries;
    }

    public Principal getRolePrincipal(String roleFullPathName) {
        RolePrincipalImpl rolePrincipal = null;
        InternalRolePrincipal internalRole = this.commonQueries.getInternalRolePrincipal(RolePrincipalImpl.getFullPathFromPrincipalName(roleFullPathName));
        if (null != internalRole) {
            rolePrincipal = new RolePrincipalImpl(RolePrincipalImpl.getPrincipalNameFromFullPath(internalRole.getFullPath()));
        }
        return rolePrincipal;
    }

    public void setRolePrincipal(RolePrincipal rolePrincipal) throws SecurityException {
        String fullPath = rolePrincipal.getFullPath();
        InternalRolePrincipal internalRole = this.commonQueries.getInternalRolePrincipal(fullPath);
        if (null == internalRole) {
            internalRole = new InternalRolePrincipalImpl(fullPath);
            internalRole.setEnabled(rolePrincipal.isEnabled());
            this.commonQueries.setInternalRolePrincipal(internalRole, false);
        } else if (!internalRole.isMappingOnly() && internalRole.isEnabled() != rolePrincipal.isEnabled()) {
            internalRole.setEnabled(rolePrincipal.isEnabled());
            this.commonQueries.setInternalRolePrincipal(internalRole, false);
        }
    }

    public void removeRolePrincipal(RolePrincipal rolePrincipal) throws SecurityException {
        InternalRolePrincipal internalRole = this.commonQueries.getInternalRolePrincipal(rolePrincipal.getFullPath());
        if (null != internalRole) {
            this.commonQueries.removeInternalRolePrincipal(internalRole);
        }
    }

    public List getRolePrincipals(String filter) {
        LinkedList<RolePrincipalImpl> rolePrincipals = new LinkedList<RolePrincipalImpl>();
        Iterator result = this.commonQueries.getInternalRolePrincipals(filter);
        while (result.hasNext()) {
            InternalRolePrincipal internalRole = (InternalRolePrincipal)result.next();
            String path = internalRole.getFullPath();
            if (path == null) continue;
            rolePrincipals.add(new RolePrincipalImpl(RolePrincipalImpl.getPrincipalNameFromFullPath(internalRole.getFullPath())));
        }
        return rolePrincipals;
    }
}

