/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl.ext;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.DefaultLoginModule;

public class JBossLoginModule
extends DefaultLoginModule {
    public JBossLoginModule() {
    }

    protected JBossLoginModule(UserManager userManager) {
        super(userManager);
    }

    protected void commitPrincipals(Subject subject, User user) {
        subject.getPrincipals().add(this.getUserPrincipal(user));
        subject.getPrincipals().add((Principal)((Object)new JBossGroup("Roles", this.getUserRoles(user))));
    }

    private static class JBossGroup
    implements Group {
        private String name;
        private ArrayList members = new ArrayList();

        public JBossGroup(String name, List members) {
            this.name = name;
            this.members.addAll(members);
        }

        public boolean addMember(Principal user) {
            if (!this.isMember(user)) {
                this.members.add(user);
                return true;
            }
            return false;
        }

        public boolean isMember(Principal member) {
            return this.members.contains(member);
        }

        public boolean removeMember(Principal user) {
            return this.members.remove(user);
        }

        public Enumeration members() {
            return Collections.enumeration(this.members);
        }

        public String getName() {
            return this.name;
        }
    }
}

