/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.jetspeed.i18n.KeyedMessage;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.om.InternalPermission;
import org.apache.jetspeed.security.om.InternalPrincipal;
import org.apache.jetspeed.security.om.impl.InternalPermissionImpl;
import org.apache.jetspeed.util.ArgUtil;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.springframework.orm.ojb.support.PersistenceBrokerDaoSupport;

public class PermissionManagerImpl
extends PersistenceBrokerDaoSupport
implements PermissionManager {
    static /* synthetic */ Class class$org$apache$jetspeed$security$om$impl$InternalPrincipalImpl;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$jetspeed$security$om$impl$InternalPermissionImpl;

    public Permissions getPermissions(Principal principal) {
        String fullPath = SecurityHelper.getPreferencesFullPath(principal);
        ArgUtil.notNull((Object[])new Object[]{fullPath}, (String[])new String[]{"fullPath"}, (String)"removePermission(java.security.Principal)");
        InternalPrincipal internalPrincipal = this.getInternalPrincipal(fullPath);
        Collection internalPermissions = new ArrayList();
        if (null != internalPrincipal) {
            internalPermissions = internalPrincipal.getPermissions();
        }
        Permissions permissions = new Permissions();
        this.appendSecurityPermissions(internalPermissions, permissions);
        return permissions;
    }

    public Permissions getPermissions(Collection principals) {
        ArgUtil.notNull((Object[])new Object[]{principals}, (String[])new String[]{"principals"}, (String)"getPermissions(java.util.Collection)");
        Permissions permissions = new Permissions();
        Collection principalsFullPath = this.getPrincipalsFullPath(principals);
        if (null != principalsFullPath && principalsFullPath.size() > 0) {
            Criteria filter = new Criteria();
            filter.addIn("fullPath", principalsFullPath);
            QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$security$om$impl$InternalPrincipalImpl == null ? (class$org$apache$jetspeed$security$om$impl$InternalPrincipalImpl = PermissionManagerImpl.class$("org.apache.jetspeed.security.om.impl.InternalPrincipalImpl")) : class$org$apache$jetspeed$security$om$impl$InternalPrincipalImpl), (Criteria)filter);
            Collection internalPrincipals = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            Iterator internalPrincipalsIter = internalPrincipals.iterator();
            while (internalPrincipalsIter.hasNext()) {
                InternalPrincipal internalPrincipal = (InternalPrincipal)internalPrincipalsIter.next();
                Collection internalPermissions = internalPrincipal.getPermissions();
                if (null == internalPermissions) continue;
                permissions = this.appendSecurityPermissions(internalPermissions, permissions);
            }
        }
        return permissions;
    }

    private Collection getPrincipalsFullPath(Collection principals) {
        ArrayList<String> principalsFullPath = new ArrayList<String>();
        Iterator principalsIterator = principals.iterator();
        while (principalsIterator.hasNext()) {
            Principal principal = (Principal)principalsIterator.next();
            String fullPath = SecurityHelper.getPreferencesFullPath(principal);
            if (null == fullPath) continue;
            principalsFullPath.add(fullPath);
        }
        return principalsFullPath;
    }

    private Permissions appendSecurityPermissions(Collection omPermissions, Permissions permissions) {
        Iterator internalPermissionsIter = omPermissions.iterator();
        while (internalPermissionsIter.hasNext()) {
            InternalPermission internalPermission = (InternalPermission)internalPermissionsIter.next();
            Permission permission = null;
            try {
                Class<?> permissionClass = Class.forName(internalPermission.getClassname());
                Class[] parameterTypes = new Class[]{class$java$lang$String == null ? PermissionManagerImpl.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? PermissionManagerImpl.class$("java.lang.String") : class$java$lang$String};
                Constructor<?> permissionConstructor = permissionClass.getConstructor(parameterTypes);
                Object[] initArgs = new Object[]{internalPermission.getName(), internalPermission.getActions()};
                permission = (Permission)permissionConstructor.newInstance(initArgs);
                if (Collections.list(permissions.elements()).contains(permission)) continue;
                permissions.add(permission);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return permissions;
    }

    public void addPermission(Permission permission) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{permission}, (String[])new String[]{"permission"}, (String)"addPermission(java.security.Permission)");
        InternalPermissionImpl internalPermission = new InternalPermissionImpl(permission.getClass().getName(), permission.getName(), permission.getActions());
        try {
            this.getPersistenceBrokerTemplate().store((Object)internalPermission);
        }
        catch (Exception e) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.addPermission", (Object)"store", (Object)e.getMessage());
            this.logger.error((Object)msg, (Throwable)e);
            throw new SecurityException(msg, (Throwable)e);
        }
    }

    public void removePermission(Permission permission) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{permission}, (String[])new String[]{"permission"}, (String)"removePermission(java.security.Permission)");
        InternalPermission internalPermission = this.getInternalPermission(permission);
        if (null != internalPermission) {
            try {
                this.getPersistenceBrokerTemplate().delete((Object)internalPermission);
            }
            catch (Exception e) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.removePermission", (Object)"delete", (Object)e.getMessage());
                this.logger.error((Object)msg, (Throwable)e);
                throw new SecurityException(msg, (Throwable)e);
            }
        }
    }

    public void removePermissions(Principal principal) throws SecurityException {
        String fullPath = SecurityHelper.getPreferencesFullPath(principal);
        ArgUtil.notNull((Object[])new Object[]{fullPath}, (String[])new String[]{"fullPath"}, (String)"removePermission(java.security.Principal)");
        InternalPrincipal internalPrincipal = this.getInternalPrincipal(fullPath);
        if (null != internalPrincipal) {
            Collection internalPermissions = internalPrincipal.getPermissions();
            if (null != internalPermissions) {
                internalPermissions.clear();
            }
            try {
                internalPrincipal.setModifiedDate(new Timestamp(System.currentTimeMillis()));
                internalPrincipal.setPermissions(internalPermissions);
                this.getPersistenceBrokerTemplate().store((Object)internalPrincipal);
            }
            catch (Exception e) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.removePermissions", (Object)"store", (Object)e.getMessage());
                this.logger.error((Object)msg, (Throwable)e);
                throw new SecurityException(msg, (Throwable)e);
            }
        }
    }

    public void grantPermission(Principal principal, Permission permission) throws SecurityException {
        String fullPath = SecurityHelper.getPreferencesFullPath(principal);
        ArgUtil.notNull((Object[])new Object[]{fullPath, permission}, (String[])new String[]{"fullPath", "permission"}, (String)"grantPermission(java.security.Principal, java.security.Permission)");
        boolean createPermission = true;
        ArrayList<InternalPermission> internalPermissions = new ArrayList<InternalPermission>();
        InternalPrincipal internalPrincipal = this.getInternalPrincipal(fullPath);
        if (null == internalPrincipal) {
            if (principal instanceof UserPrincipal) {
                throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)principal.getName()));
            }
            if (principal instanceof RolePrincipal) {
                throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST.create((Object)principal.getName()));
            }
            throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)principal.getName()));
        }
        InternalPermission internalPermission = this.getInternalPermission(permission);
        if (null == internalPermission) {
            throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
        }
        if (null != internalPrincipal.getPermissions()) {
            internalPermissions.addAll(internalPrincipal.getPermissions());
        }
        if (!internalPermissions.contains(internalPermission)) {
            internalPermissions.add(internalPermission);
        }
        try {
            internalPrincipal.setModifiedDate(new Timestamp(System.currentTimeMillis()));
            internalPrincipal.setPermissions(internalPermissions);
            this.getPersistenceBrokerTemplate().store((Object)internalPrincipal);
        }
        catch (Exception e) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.grantPermission", (Object)"store", (Object)e.getMessage());
            this.logger.error((Object)msg, (Throwable)e);
            throw new SecurityException(msg, (Throwable)e);
        }
    }

    public boolean permissionExists(Permission permission) {
        boolean permissionExists = true;
        InternalPermission internalPermission = this.getInternalPermission(permission);
        if (null == internalPermission) {
            permissionExists = false;
        }
        return permissionExists;
    }

    public void revokePermission(Principal principal, Permission permission) throws SecurityException {
        Collection internalPermissions;
        String fullPath = SecurityHelper.getPreferencesFullPath(principal);
        ArgUtil.notNull((Object[])new Object[]{fullPath, permission}, (String[])new String[]{"fullPath", "permission"}, (String)"revokePermission(java.security.Principal, java.security.Permission)");
        InternalPrincipal internalPrincipal = this.getInternalPrincipal(fullPath);
        if (null != internalPrincipal && null != (internalPermissions = internalPrincipal.getPermissions())) {
            boolean revokePermission = false;
            ArrayList<InternalPermission> newInternalPermissions = new ArrayList<InternalPermission>();
            Iterator internalPermissionsIter = internalPermissions.iterator();
            while (internalPermissionsIter.hasNext()) {
                InternalPermission internalPermission = (InternalPermission)internalPermissionsIter.next();
                if (!(internalPermission.getClassname().equals(permission.getClass().getName()) && internalPermission.getName().equals(permission.getName()) && internalPermission.getActions().equals(permission.getActions()))) {
                    newInternalPermissions.add(internalPermission);
                    continue;
                }
                revokePermission = true;
            }
            if (revokePermission) {
                try {
                    internalPrincipal.setModifiedDate(new Timestamp(System.currentTimeMillis()));
                    internalPrincipal.setPermissions(newInternalPermissions);
                    this.getPersistenceBrokerTemplate().store((Object)internalPrincipal);
                }
                catch (Exception e) {
                    KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.revokePermission", (Object)"store", (Object)e.getMessage());
                    this.logger.error((Object)msg, (Throwable)e);
                    throw new SecurityException(msg, (Throwable)e);
                }
            }
        }
    }

    InternalPrincipal getInternalPrincipal(String fullPath) {
        Criteria filter = new Criteria();
        filter.addEqualTo("fullPath", (Object)fullPath);
        QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$security$om$impl$InternalPrincipalImpl == null ? (class$org$apache$jetspeed$security$om$impl$InternalPrincipalImpl = PermissionManagerImpl.class$("org.apache.jetspeed.security.om.impl.InternalPrincipalImpl")) : class$org$apache$jetspeed$security$om$impl$InternalPrincipalImpl), (Criteria)filter);
        InternalPrincipal internalPrincipal = (InternalPrincipal)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        return internalPrincipal;
    }

    InternalPermission getInternalPermission(Permission permission) {
        Criteria filter = new Criteria();
        filter.addEqualTo("classname", (Object)permission.getClass().getName());
        filter.addEqualTo("name", (Object)permission.getName());
        filter.addEqualTo("actions", (Object)permission.getActions());
        QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$security$om$impl$InternalPermissionImpl == null ? (class$org$apache$jetspeed$security$om$impl$InternalPermissionImpl = PermissionManagerImpl.class$("org.apache.jetspeed.security.om.impl.InternalPermissionImpl")) : class$org$apache$jetspeed$security$om$impl$InternalPermissionImpl), (Criteria)filter);
        InternalPermission internalPermission = (InternalPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        return internalPermission;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

