/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.i18n.KeyedMessage;
import org.apache.jetspeed.security.AuthenticationProviderProxy;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SecurityProvider;
import org.apache.jetspeed.security.impl.GroupImpl;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.spi.GroupSecurityHandler;
import org.apache.jetspeed.security.spi.SecurityMappingHandler;
import org.apache.jetspeed.util.ArgUtil;

public class GroupManagerImpl
implements GroupManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$impl$GroupManagerImpl == null ? (class$org$apache$jetspeed$security$impl$GroupManagerImpl = GroupManagerImpl.class$("org.apache.jetspeed.security.impl.GroupManagerImpl")) : class$org$apache$jetspeed$security$impl$GroupManagerImpl));
    private AuthenticationProviderProxy atnProviderProxy = null;
    private GroupSecurityHandler groupSecurityHandler = null;
    private SecurityMappingHandler securityMappingHandler = null;
    static /* synthetic */ Class class$org$apache$jetspeed$security$impl$GroupManagerImpl;

    public GroupManagerImpl(SecurityProvider securityProvider) {
        this.atnProviderProxy = securityProvider.getAuthenticationProviderProxy();
        this.groupSecurityHandler = securityProvider.getGroupSecurityHandler();
        this.securityMappingHandler = securityProvider.getSecurityMappingHandler();
    }

    public void addGroup(String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{groupFullPathName}, (String[])new String[]{"groupFullPathName"}, (String)"addGroup(java.lang.String)");
        if (this.groupExists(groupFullPathName)) {
            throw new SecurityException(SecurityException.GROUP_ALREADY_EXISTS.create((Object)groupFullPathName));
        }
        GroupPrincipalImpl groupPrincipal = new GroupPrincipalImpl(groupFullPathName);
        String fullPath = groupPrincipal.getFullPath();
        Preferences preferences = Preferences.userRoot().node(fullPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added group preferences node: " + fullPath));
        }
        try {
            if (null != preferences && preferences.absolutePath().equals(fullPath)) {
                this.groupSecurityHandler.setGroupPrincipal(groupPrincipal);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added group: " + fullPath));
                }
            }
        }
        catch (SecurityException se) {
            String msg = "Unable to create the role.";
            log.error((Object)msg, (Throwable)se);
            try {
                preferences.removeNode();
            }
            catch (BackingStoreException bse) {
                bse.printStackTrace();
            }
            throw se;
        }
    }

    public void removeGroup(String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{groupFullPathName}, (String[])new String[]{"groupFullPathName"}, (String)"removeGroup(java.lang.String)");
        Preferences prefs = Preferences.userRoot().node(GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName));
        String[] groups = this.securityMappingHandler.getGroupHierarchyResolver().resolveChildren(prefs);
        for (int i = 0; i < groups.length; ++i) {
            try {
                this.groupSecurityHandler.removeGroupPrincipal(new GroupPrincipalImpl(GroupPrincipalImpl.getPrincipalNameFromFullPath(groups[i])));
            }
            catch (SecurityException se) {
                throw se;
            }
            catch (Exception e) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"GroupManager.removeGroup", (Object)("GroupSecurityHandler.removeGroupPrincipal(" + GroupPrincipalImpl.getPrincipalNameFromFullPath(groups[i]) + ")"), (Object)e.getMessage());
                log.error((Object)msg, (Throwable)e);
                throw new SecurityException(msg, (Throwable)e);
            }
            Preferences groupPref = Preferences.userRoot().node(groups[i]);
            try {
                groupPref.removeNode();
                continue;
            }
            catch (BackingStoreException bse) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)("Preferences.removeNode(" + groups[i] + ")"), (Object)bse.getMessage());
                log.error((Object)msg, (Throwable)bse);
                throw new SecurityException(msg, (Throwable)bse);
            }
        }
    }

    public boolean groupExists(String groupFullPathName) {
        boolean groupExists;
        ArgUtil.notNull((Object[])new Object[]{groupFullPathName}, (String[])new String[]{"groupFullPathName"}, (String)"groupExists(java.lang.String)");
        Principal principal = this.groupSecurityHandler.getGroupPrincipal(groupFullPathName);
        boolean bl = groupExists = null != principal;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Role exists: " + groupExists));
            log.debug((Object)("Role: " + groupFullPathName));
        }
        return groupExists;
    }

    public Group getGroup(String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{groupFullPathName}, (String[])new String[]{"groupFullPathName"}, (String)"getGroup(java.lang.String)");
        String fullPath = GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName);
        Principal groupPrincipal = this.groupSecurityHandler.getGroupPrincipal(groupFullPathName);
        if (null == groupPrincipal) {
            throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)groupFullPathName));
        }
        Preferences preferences = Preferences.userRoot().node(fullPath);
        GroupImpl group = new GroupImpl(groupPrincipal, preferences);
        return group;
    }

    public Collection getGroupsForUser(String username) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username}, (String[])new String[]{"username"}, (String)"getGroupsForUser(java.lang.String)");
        ArrayList<GroupImpl> groups = new ArrayList<GroupImpl>();
        Set groupPrincipals = this.securityMappingHandler.getGroupPrincipals(username);
        Iterator groupPrincipalsIter = groupPrincipals.iterator();
        while (groupPrincipalsIter.hasNext()) {
            Principal groupPrincipal = (Principal)groupPrincipalsIter.next();
            Preferences preferences = Preferences.userRoot().node(GroupPrincipalImpl.getFullPathFromPrincipalName(groupPrincipal.getName()));
            groups.add(new GroupImpl(groupPrincipal, preferences));
        }
        return groups;
    }

    public Collection getGroupsInRole(String roleFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName}, (String[])new String[]{"roleFullPathName"}, (String)"getGroupsInRole(java.lang.String)");
        ArrayList<GroupImpl> groups = new ArrayList<GroupImpl>();
        Set groupPrincipals = this.securityMappingHandler.getGroupPrincipalsInRole(roleFullPathName);
        Iterator groupPrincipalsIter = groupPrincipals.iterator();
        while (groupPrincipalsIter.hasNext()) {
            Principal groupPrincipal = (Principal)groupPrincipalsIter.next();
            Preferences preferences = Preferences.userRoot().node(GroupPrincipalImpl.getFullPathFromPrincipalName(groupPrincipal.getName()));
            groups.add(new GroupImpl(groupPrincipal, preferences));
        }
        return groups;
    }

    public void addUserToGroup(String username, String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username, groupFullPathName}, (String[])new String[]{"username", "groupFullPathName"}, (String)"addUserToGroup(java.lang.String, java.lang.String)");
        Principal groupPrincipal = this.groupSecurityHandler.getGroupPrincipal(groupFullPathName);
        if (null == groupPrincipal) {
            throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)groupFullPathName));
        }
        Principal userPrincipal = this.atnProviderProxy.getUserPrincipal(username);
        if (null == userPrincipal) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)username));
        }
        Set groupPrincipals = this.securityMappingHandler.getGroupPrincipals(username);
        if (!groupPrincipals.contains(groupPrincipal)) {
            this.securityMappingHandler.setUserPrincipalInGroup(username, groupFullPathName);
        }
    }

    public void removeUserFromGroup(String username, String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username, groupFullPathName}, (String[])new String[]{"username", "groupFullPathName"}, (String)"removeUserFromGroup(java.lang.String, java.lang.String)");
        Principal userPrincipal = this.atnProviderProxy.getUserPrincipal(username);
        if (null == userPrincipal) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)username));
        }
        Principal groupPrincipal = this.groupSecurityHandler.getGroupPrincipal(groupFullPathName);
        if (null != groupPrincipal) {
            this.securityMappingHandler.removeUserPrincipalInGroup(username, groupFullPathName);
        }
    }

    public boolean isUserInGroup(String username, String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username, groupFullPathName}, (String[])new String[]{"username", "groupFullPathName"}, (String)"isUserInGroup(java.lang.String, java.lang.String)");
        boolean isUserInGroup = false;
        Set groupPrincipals = this.securityMappingHandler.getGroupPrincipals(username);
        GroupPrincipalImpl groupPrincipal = new GroupPrincipalImpl(groupFullPathName);
        if (groupPrincipals.contains(groupPrincipal)) {
            isUserInGroup = true;
        }
        return isUserInGroup;
    }

    public Iterator getGroups(String filter) throws SecurityException {
        LinkedList<Group> groups = new LinkedList<Group>();
        Iterator groupPrincipals = this.groupSecurityHandler.getGroupPrincipals(filter).iterator();
        while (groupPrincipals.hasNext()) {
            String groupName = ((Principal)groupPrincipals.next()).getName();
            Group group = this.getGroup(groupName);
            groups.add(group);
        }
        return groups.iterator();
    }

    public void setGroupEnabled(String groupFullPathName, boolean enabled) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{groupFullPathName}, (String[])new String[]{"groupFullPathName"}, (String)"setGroupEnabled(java.lang.String,boolean)");
        String fullPath = GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName);
        GroupPrincipalImpl groupPrincipal = (GroupPrincipalImpl)((Object)this.groupSecurityHandler.getGroupPrincipal(groupFullPathName));
        if (null == groupPrincipal) {
            throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)groupFullPathName));
        }
        if (enabled != groupPrincipal.isEnabled()) {
            groupPrincipal.setEnabled(enabled);
            this.groupSecurityHandler.setGroupPrincipal(groupPrincipal);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

