/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.jetspeed.security.AuthenticationProvider;
import org.apache.jetspeed.security.AuthenticationProviderProxy;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.UserPrincipal;

public class AuthenticationProviderProxyImpl
implements AuthenticationProviderProxy {
    private List authenticationProviders = new ArrayList();
    private String defaultAuthenticationProvider = null;

    public AuthenticationProviderProxyImpl(List authenticationProviders, String defaultAuthenticationProvider) {
        this.authenticationProviders = authenticationProviders;
        this.defaultAuthenticationProvider = defaultAuthenticationProvider;
    }

    protected AuthenticationProvider getAuthenticationProviderByName(String providerName) {
        AuthenticationProvider provider = null;
        for (int i = 0; i < this.authenticationProviders.size() && !providerName.equals((provider = (AuthenticationProvider)this.authenticationProviders.get(i)).getProviderName()); ++i) {
            provider = null;
        }
        return provider;
    }

    public String getDefaultAuthenticationProvider() {
        return this.defaultAuthenticationProvider;
    }

    public String getAuthenticationProvider(String userName) {
        String providerName = null;
        for (int i = 0; i < this.authenticationProviders.size(); ++i) {
            AuthenticationProvider authenticationProvider = (AuthenticationProvider)this.authenticationProviders.get(i);
            if (!authenticationProvider.getUserSecurityHandler().isUserPrincipal(userName)) continue;
            providerName = authenticationProvider.getProviderName();
            break;
        }
        return providerName;
    }

    public boolean isUserPrincipal(String userName) {
        boolean exists = false;
        for (int i = 0; i < this.authenticationProviders.size() && !(exists = ((AuthenticationProvider)this.authenticationProviders.get(i)).getUserSecurityHandler().isUserPrincipal(userName)); ++i) {
        }
        return exists;
    }

    public Principal getUserPrincipal(String username) {
        Principal userPrincipal = null;
        for (int i = 0; i < this.authenticationProviders.size() && null == (userPrincipal = ((AuthenticationProvider)this.authenticationProviders.get(i)).getUserSecurityHandler().getUserPrincipal(username)); ++i) {
        }
        return userPrincipal;
    }

    public List getUserPrincipals(String filter) {
        LinkedList userPrincipals = new LinkedList();
        for (int i = 0; i < this.authenticationProviders.size(); ++i) {
            userPrincipals.addAll(((AuthenticationProvider)this.authenticationProviders.get(i)).getUserSecurityHandler().getUserPrincipals(filter));
        }
        return userPrincipals;
    }

    public void addUserPrincipal(UserPrincipal userPrincipal, String authenticationProvider) throws SecurityException {
        AuthenticationProvider provider = this.getAuthenticationProviderByName(authenticationProvider);
        if (provider == null) {
            throw new SecurityException(SecurityException.INVALID_AUTHENTICATION_PROVIDER.create((Object)authenticationProvider));
        }
        provider.getUserSecurityHandler().addUserPrincipal(userPrincipal);
    }

    public void addUserPrincipal(UserPrincipal userPrincipal) throws SecurityException {
        String providerName = this.getAuthenticationProvider(userPrincipal.getName());
        if (providerName != null) {
            throw new SecurityException(SecurityException.USER_ALREADY_EXISTS.create((Object)userPrincipal.getName()));
        }
        this.addUserPrincipal(userPrincipal, this.defaultAuthenticationProvider);
    }

    public void updateUserPrincipal(UserPrincipal userPrincipal, String authenticationProvider) throws SecurityException {
        AuthenticationProvider provider = this.getAuthenticationProviderByName(authenticationProvider);
        if (provider == null) {
            throw new SecurityException(SecurityException.INVALID_AUTHENTICATION_PROVIDER.create((Object)authenticationProvider));
        }
        provider.getUserSecurityHandler().updateUserPrincipal(userPrincipal);
    }

    public void updateUserPrincipal(UserPrincipal userPrincipal) throws SecurityException {
        String providerName = this.getAuthenticationProvider(userPrincipal.getName());
        if (providerName == null) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userPrincipal.getName()));
        }
        this.updateUserPrincipal(userPrincipal, providerName);
    }

    public void removeUserPrincipal(UserPrincipal userPrincipal, String authenticationProvider) throws SecurityException {
        AuthenticationProvider provider = this.getAuthenticationProviderByName(authenticationProvider);
        if (provider == null) {
            throw new SecurityException(SecurityException.INVALID_AUTHENTICATION_PROVIDER.create((Object)authenticationProvider));
        }
        provider.getUserSecurityHandler().removeUserPrincipal(userPrincipal);
    }

    public void removeUserPrincipal(UserPrincipal userPrincipal) throws SecurityException {
        String providerName = this.getAuthenticationProvider(userPrincipal.getName());
        if (providerName != null) {
            this.removeUserPrincipal(userPrincipal, providerName);
        }
    }

    public Set getPublicCredentials(String username) {
        HashSet publicCredentials = new HashSet();
        String providerName = this.getAuthenticationProvider(username);
        if (providerName != null) {
            AuthenticationProvider provider = this.getAuthenticationProviderByName(providerName);
            publicCredentials.addAll(provider.getCredentialHandler().getPublicCredentials(username));
        }
        return publicCredentials;
    }

    public void setPassword(String userName, String oldPassword, String newPassword, String authenticationProvider) throws SecurityException {
        AuthenticationProvider provider = this.getAuthenticationProviderByName(authenticationProvider);
        if (provider == null) {
            throw new SecurityException(SecurityException.INVALID_AUTHENTICATION_PROVIDER.create((Object)authenticationProvider));
        }
        provider.getCredentialHandler().setPassword(userName, oldPassword, newPassword);
    }

    public void setPassword(String userName, String oldPassword, String newPassword) throws SecurityException {
        String providerName = this.getAuthenticationProvider(userName);
        if (providerName == null) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
        this.setPassword(userName, oldPassword, newPassword, providerName);
    }

    public Set getPrivateCredentials(String username) {
        HashSet privateCredentials = new HashSet();
        String providerName = this.getAuthenticationProvider(username);
        if (providerName != null) {
            AuthenticationProvider provider = this.getAuthenticationProviderByName(providerName);
            privateCredentials.addAll(provider.getCredentialHandler().getPrivateCredentials(username));
        }
        return privateCredentials;
    }

    public void setPasswordEnabled(String userName, boolean enabled, String authenticationProvider) throws SecurityException {
        AuthenticationProvider provider = this.getAuthenticationProviderByName(authenticationProvider);
        if (provider == null) {
            throw new SecurityException(SecurityException.INVALID_AUTHENTICATION_PROVIDER.create((Object)authenticationProvider));
        }
        provider.getCredentialHandler().setPasswordEnabled(userName, enabled);
    }

    public void setPasswordEnabled(String userName, boolean enabled) throws SecurityException {
        String providerName = this.getAuthenticationProvider(userName);
        if (providerName == null) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
        this.setPasswordEnabled(userName, enabled, providerName);
    }

    public void setPasswordUpdateRequired(String userName, boolean updateRequired, String authenticationProvider) throws SecurityException {
        AuthenticationProvider provider = this.getAuthenticationProviderByName(authenticationProvider);
        if (provider == null) {
            throw new SecurityException(SecurityException.INVALID_AUTHENTICATION_PROVIDER.create((Object)authenticationProvider));
        }
        provider.getCredentialHandler().setPasswordUpdateRequired(userName, updateRequired);
    }

    public void setPasswordUpdateRequired(String userName, boolean updateRequired) throws SecurityException {
        String providerName = this.getAuthenticationProvider(userName);
        if (providerName == null) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
        this.setPasswordUpdateRequired(userName, updateRequired, providerName);
    }

    public boolean authenticate(String userName, String password, String authenticationProvider) throws SecurityException {
        AuthenticationProvider provider = this.getAuthenticationProviderByName(authenticationProvider);
        if (provider != null) {
            return provider.getCredentialHandler().authenticate(userName, password);
        }
        throw new SecurityException(SecurityException.INVALID_AUTHENTICATION_PROVIDER.create((Object)authenticationProvider));
    }

    public boolean authenticate(String userName, String password) throws SecurityException {
        String providerName = this.getAuthenticationProvider(userName);
        if (providerName != null) {
            return this.authenticate(userName, password, providerName);
        }
        throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
    }
}

