/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;

public class SecurityHelper {
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;
    static /* synthetic */ Class class$org$apache$jetspeed$security$RolePrincipal;
    static /* synthetic */ Class class$org$apache$jetspeed$security$GroupPrincipal;

    public static Principal getPrincipal(Subject subject, Class classe) {
        Principal principal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (!classe.isInstance(p)) continue;
            principal = p;
            break;
        }
        return principal;
    }

    public static Principal getBestPrincipal(Subject subject, Class classe) {
        Principal principal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (classe.isInstance(p)) {
                principal = p;
                break;
            }
            if (principal != null) continue;
            principal = p;
        }
        return principal;
    }

    public static String getPreferencesFullPath(Principal principal) {
        if ((class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = SecurityHelper.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal).isInstance(principal)) {
            return UserPrincipalImpl.getFullPathFromPrincipalName(principal.getName());
        }
        if ((class$org$apache$jetspeed$security$RolePrincipal == null ? (class$org$apache$jetspeed$security$RolePrincipal = SecurityHelper.class$("org.apache.jetspeed.security.RolePrincipal")) : class$org$apache$jetspeed$security$RolePrincipal).isInstance(principal)) {
            return RolePrincipalImpl.getFullPathFromPrincipalName(principal.getName());
        }
        if ((class$org$apache$jetspeed$security$GroupPrincipal == null ? (class$org$apache$jetspeed$security$GroupPrincipal = SecurityHelper.class$("org.apache.jetspeed.security.GroupPrincipal")) : class$org$apache$jetspeed$security$GroupPrincipal).isInstance(principal)) {
            return GroupPrincipalImpl.getFullPathFromPrincipalName(principal.getName());
        }
        return null;
    }

    public static Subject createSubject(String principalName) {
        UserPrincipalImpl principal = new UserPrincipalImpl(principalName);
        HashSet<UserPrincipalImpl> principals = new HashSet<UserPrincipalImpl>();
        principals.add(principal);
        return new Subject(true, principals, new HashSet(), new HashSet());
    }

    public static List getPrincipals(Subject subject, Class classe) {
        LinkedList<Principal> result = new LinkedList<Principal>();
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (!classe.isInstance(p)) continue;
            result.add(p);
        }
        return result;
    }

    public static PasswordCredential getPasswordCredential(Subject subject) {
        Iterator<Object> iter = subject.getPrivateCredentials().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof PasswordCredential)) continue;
            return (PasswordCredential)o;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

