/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.search.handlers.pam;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.apache.jetspeed.om.common.LocalizedField;
import org.apache.jetspeed.om.common.portlet.PortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.search.AbstractObjectHandler;
import org.apache.jetspeed.search.BaseParsedObject;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.DisplayName;
import org.apache.pluto.om.common.Language;

public class PortletDefinitionHandler
extends AbstractObjectHandler {
    private static final String KEY_PREFIX = "PortletDefinition::";
    private static final String ID = "ID";
    private static final String PORTLET_APPLICATION = "portlet_application";

    public PortletDefinitionHandler() {
        this.fields.add(ID);
        this.fields.add(PORTLET_APPLICATION);
    }

    public ParsedObject parseObject(Object o) {
        BaseParsedObject result = null;
        if (o instanceof PortletDefinitionComposite) {
            result = new BaseParsedObject();
            PortletDefinitionComposite pd = (PortletDefinitionComposite)o;
            String displayNameText = pd.getDisplayNameText(JetspeedLocale.getDefaultLocale());
            result.setTitle(displayNameText);
            String description = pd.getDescriptionText(JetspeedLocale.getDefaultLocale());
            result.setDescription(description);
            result.setClassName(pd.getClass().getName());
            result.setKey(KEY_PREFIX + pd.getUniqueName());
            result.setType("portlet");
            MultiHashMap fieldMap = new MultiHashMap();
            fieldMap.put((Object)ID, (Object)pd.getName());
            PortletApplication pa = (PortletApplication)pd.getPortletApplicationDefinition();
            fieldMap.put((Object)PORTLET_APPLICATION, (Object)pa.getName());
            Collection mdFields = pd.getMetadata().getFields();
            Iterator fieldIter = mdFields.iterator();
            while (fieldIter.hasNext()) {
                LocalizedField field = (LocalizedField)fieldIter.next();
                fieldMap.put((Object)field.getName(), (Object)field.getValue());
            }
            Iterator descIter = pd.getDescriptionSet().iterator();
            while (descIter.hasNext()) {
                Description desc = (Description)descIter.next();
                fieldMap.put((Object)"fieldname.description", (Object)desc.getDescription());
            }
            Iterator displayNameIter = pd.getDisplayNameSet().iterator();
            while (displayNameIter.hasNext()) {
                DisplayName displayName = (DisplayName)displayNameIter.next();
                fieldMap.put((Object)"fieldname.title", (Object)displayName.getDisplayName());
            }
            HashSet<String> keywordSet = new HashSet<String>();
            Iterator langIter = pd.getLanguageSet().iterator();
            while (langIter.hasNext()) {
                Language lang = (Language)langIter.next();
                fieldMap.put((Object)"fieldname.title", (Object)lang.getTitle());
                fieldMap.put((Object)"fieldname.title", (Object)lang.getShortTitle());
                Iterator keywordIter = lang.getKeywords();
                if (keywordIter == null) continue;
                while (keywordIter.hasNext()) {
                    String keyword = (String)keywordIter.next();
                    keywordSet.add(keyword);
                }
            }
            String[] temp = new String[keywordSet.size()];
            result.setKeywords(keywordSet.toArray(temp));
            result.setFields((Map)fieldMap);
        }
        return result;
    }
}

