/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.RuleCriterionResolver;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityHelper;

public class StandardResolver
implements RuleCriterionResolver {
    public static final String VALUE_DELIMITER = ",";

    public String resolve(RequestContext context, RuleCriterion criterion) {
        String value = context.getRequestParameter(criterion.getName());
        if (value == null) {
            value = criterion.getValue();
        }
        return value;
    }

    public boolean isControl(RuleCriterion criterion) {
        return !criterion.getName().equals("path") && !criterion.getName().equals("page");
    }

    public boolean isNavigation(RuleCriterion criterion) {
        return false;
    }

    protected String resolvePrincipals(RequestContext context, RuleCriterion criterion, Subject subject, Class classe) {
        StringBuffer result = new StringBuffer();
        Iterator principals = SecurityHelper.getPrincipals((Subject)subject, (Class)classe).iterator();
        int count = 0;
        while (principals.hasNext()) {
            Principal principal = (Principal)principals.next();
            if (count > 0) {
                result.append(VALUE_DELIMITER);
            }
            result.append(principal.getName());
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return result.toString();
    }
}

