/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.Serializable;
import java.util.StringTokenizer;

public class Path
implements Serializable {
    public static final String PATH_SEPERATOR = "/";
    private final String path;
    private final String[] segments;
    private final String fileName;
    private final String baseName;
    private final String fileExtension;
    private final String queryString;
    private final String pathOnly;

    public Path(String path) {
        this.path = path;
        String[] split = path.split("\\?");
        this.pathOnly = split[0];
        StringTokenizer t = new StringTokenizer(this.pathOnly, PATH_SEPERATOR);
        this.segments = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            this.segments[i] = t.nextToken();
            ++i;
        }
        this.fileName = this.segments[this.segments.length - 1];
        int extIndex = this.fileName.lastIndexOf(46);
        if (extIndex > -1) {
            this.baseName = this.fileName.substring(0, extIndex);
            this.fileExtension = this.fileName.substring(extIndex);
        } else {
            this.baseName = this.fileName;
            this.fileExtension = null;
        }
        this.queryString = split.length > 1 ? split[1] : null;
    }

    public String getSegment(int i) {
        return this.segments[i];
    }

    public Path getSubPath(int beginAtSegment) {
        StringBuffer newPathString = new StringBuffer();
        for (int i = beginAtSegment; i < this.segments.length; ++i) {
            newPathString.append(PATH_SEPERATOR).append(this.segments[i]);
        }
        if (this.queryString != null) {
            newPathString.append("?").append(this.queryString);
        }
        return new Path(newPathString.toString());
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public int length() {
        return this.segments.length;
    }

    public String toString() {
        return this.path;
    }

    public String pathOnly() {
        return this.pathOnly;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            return ((Path)obj).path.equals(this.path);
        }
        return false;
    }

    public int hashCode() {
        return (this.getClass().getName() + "::" + this.path).hashCode();
    }
}

