/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.Serializable;
import org.apache.jetspeed.util.PortalObjectID;
import org.apache.pluto.om.portlet.PortletDefinition;

public class JetspeedObjectID
implements PortalObjectID,
Serializable {
    private String stringOID = null;
    private long oid;

    public JetspeedObjectID(long oid) {
        this.stringOID = String.valueOf(oid);
        this.oid = oid;
    }

    public JetspeedObjectID(long oid, String stringOID) {
        this.stringOID = stringOID;
        this.oid = oid;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof JetspeedObjectID) {
            result = this.oid == ((JetspeedObjectID)object).oid;
        } else if (object instanceof String) {
            result = this.stringOID.equals(object);
        } else if (object instanceof Long) {
            result = this.oid == (Long)object;
        } else if (object instanceof Integer) {
            result = this.oid == (long)((Integer)object).intValue();
        }
        return result;
    }

    public int hashCode() {
        return (int)this.oid;
    }

    public String toString() {
        return this.stringOID;
    }

    public long longValue() {
        return this.oid;
    }

    public static JetspeedObjectID createFromString(String idStr) {
        char[] id = idStr.toCharArray();
        long _id = 1L;
        for (int i = 0; i < id.length; ++i) {
            _id = i % 2 == 0 ? (_id *= (long)id[i]) : (_id ^= (long)id[i]);
            _id = Math.abs(_id);
        }
        return new JetspeedObjectID(_id, idStr);
    }

    public static JetspeedObjectID createPortletEntityId(PortletDefinition portletDefinition, String instanceName) {
        return JetspeedObjectID.createFromString(portletDefinition.getName() + ":" + portletDefinition.getId().toString() + ":" + instanceName);
    }

    public long getOID() {
        return this.oid;
    }
}

