/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.util.Locale;
import java.util.StringTokenizer;

public class JetspeedLocale {
    private static final String DELIM = ",";

    public static Locale getDefaultLocale() {
        return Locale.ENGLISH;
    }

    public static String convertLocaleToString(Locale locale) {
        if (locale == null) {
            return null;
        }
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String variant = locale.getVariant();
        StringBuffer buffer = new StringBuffer(40);
        if (language != null) {
            buffer.append(language);
        }
        buffer.append(DELIM);
        if (country != null) {
            buffer.append(country);
        }
        buffer.append(DELIM);
        if (variant != null) {
            buffer.append(variant);
        }
        return buffer.toString().trim();
    }

    public static Locale convertStringToLocale(String localeString) {
        if (localeString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(localeString, DELIM);
        String language = tokenizer.nextToken().trim();
        String country = null;
        String variant = null;
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken().trim();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken().trim();
        }
        if (country != null && language != null && variant != null) {
            return new Locale(language, country, variant);
        }
        if (country != null && language != null) {
            return new Locale(language, country);
        }
        if (language != null) {
            return new Locale(language, "");
        }
        return null;
    }
}

