/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.PortalResourcePermission;
import org.apache.jetspeed.security.PortalResourcePermissionCollection;

public class PortletPermission
extends PortalResourcePermission {
    public PortletPermission(String name, String actions) {
        this(name, actions, null);
    }

    public PortletPermission(String name, String actions, Subject subject) {
        super(name, actions, subject);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PortletPermission)) {
            return false;
        }
        if (!permission.getName().equals(this.getName())) {
            return false;
        }
        PortletPermission portletPerm = (PortletPermission)permission;
        Subject user = portletPerm.getSubject();
        if (null == user) {
            AccessControlContext context = AccessController.getContext();
            user = Subject.getSubject(context);
        }
        if (null == user) {
            return false;
        }
        return (this.mask & portletPerm.mask) == portletPerm.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new PortalResourcePermissionCollection();
    }
}

