/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.security.Permission;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.security.PortletPermission;

public abstract class PortalResourcePermission
extends Permission {
    protected int mask;
    protected Subject subject;

    public PortalResourcePermission(String name, String actions, Subject subject) {
        super(name);
        this.parseActions(actions);
        this.subject = subject;
    }

    public int hashCode() {
        StringBuffer value = new StringBuffer(this.getName());
        return value.toString().hashCode() ^ this.mask;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PortletPermission)) {
            return false;
        }
        PortletPermission p = (PortletPermission)object;
        boolean isEqual = p.getName().equals(this.getName()) && p.mask == this.mask;
        return isEqual;
    }

    public String getActions() {
        StringBuffer buf = new StringBuffer();
        if ((this.mask & 8) == 8) {
            buf.append(JetspeedActions.VIEW);
        }
        if ((this.mask & 0x10) == 16) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(JetspeedActions.EDIT);
        }
        if ((this.mask & 4) == 4) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(JetspeedActions.RESTORE);
        }
        if ((this.mask & 1) == 1) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(JetspeedActions.MINIMIZE);
        }
        if ((this.mask & 2) == 2) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(JetspeedActions.MAXIMIZE);
        }
        if ((this.mask & 0x20) == 32) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(JetspeedActions.HELP);
        }
        if ((this.mask & 0x40) == 64) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(JetspeedActions.SECURE);
        }
        return buf.toString();
    }

    public boolean implies(Permission permission) {
        return false;
    }

    private void parseActions(String actions) {
        this.mask = 0;
        if (actions != null) {
            StringTokenizer tokenizer = new StringTokenizer(actions, ",\t ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals(JetspeedActions.VIEW)) {
                    this.mask |= 8;
                    continue;
                }
                if (token.equals(JetspeedActions.VIEW) || token.equals(JetspeedActions.RESTORE)) {
                    this.mask |= 8;
                    continue;
                }
                if (token.equals(JetspeedActions.EDIT)) {
                    this.mask |= 0x10;
                    continue;
                }
                if (token.equals(JetspeedActions.MINIMIZE)) {
                    this.mask |= 1;
                    continue;
                }
                if (token.equals(JetspeedActions.MAXIMIZE)) {
                    this.mask |= 2;
                    continue;
                }
                if (token.equals(JetspeedActions.HELP)) {
                    this.mask |= 0x20;
                    continue;
                }
                if (token.equals(JetspeedActions.SECURE)) {
                    this.mask |= 0x40;
                    continue;
                }
                throw new IllegalArgumentException("Unknown action: " + token);
            }
        }
    }

    public Subject getSubject() {
        return this.subject;
    }
}

