/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.dispatcher;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.core.impl.RenderRequestImpl;
import org.apache.pluto.core.impl.RenderResponseImpl;

public class JetspeedRequestDispatcher
implements PortletRequestDispatcher {
    private RequestDispatcher requestDispatcher;

    public JetspeedRequestDispatcher(RequestDispatcher requestDispatcher) {
        if (requestDispatcher == null) {
            throw new IllegalArgumentException("RequestDispatcher cannot be null for JetspeedRequestDispatcher.");
        }
        this.requestDispatcher = requestDispatcher;
    }

    public void include(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        HttpServletResponse servletResponse = null;
        try {
            HttpServletRequest servletRequest = (HttpServletRequest)((RenderRequestImpl)request).getRequest();
            servletResponse = (HttpServletResponse)((RenderResponseImpl)response).getResponse();
            this.requestDispatcher.include((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (Exception e) {
            PrintWriter pw = null;
            if (servletResponse != null) {
                pw = JetspeedRequestDispatcher.getPrintWriter(servletResponse);
                pw.write("JetspeedRequestDispatcher failed to include servlet resources. (details below) <br/>");
                pw.write("Exception: " + e.getClass().getName() + " <br/>");
                pw.write("Message: " + e.getMessage() + " <br/>");
                JetspeedRequestDispatcher.writeStackTrace(e.getStackTrace(), pw);
            }
            if (e.getCause() != null) {
                if (pw != null) {
                    pw.write("<p>Root Cause: </p>");
                    pw.write("Message: " + e.getCause().getMessage() + " <br/>");
                    pw.write("Exception: " + e.getCause().getClass().getName() + " <br/>");
                    JetspeedRequestDispatcher.writeStackTrace(e.getCause().getStackTrace(), pw);
                }
                pw.flush();
                throw new PortletException((Throwable)e);
            }
            pw.flush();
            throw new PortletException((Throwable)e);
        }
    }

    protected static final void writeStackTrace(StackTraceElement[] traceArray, PrintWriter pw) {
        pw.write("<p>Stack Trace: </p>");
        for (int i = 0; i < traceArray.length; ++i) {
            pw.write("&nbsp;&nbsp;&nbsp;" + traceArray[i].toString() + "<br />");
        }
    }

    private static final PrintWriter getPrintWriter(ServletResponse response) throws IOException {
        PrintWriter pw = null;
        try {
            pw = response.getWriter();
        }
        catch (IllegalStateException ise) {
            pw = new PrintWriter((OutputStream)response.getOutputStream());
        }
        return pw;
    }
}

