/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.apache.jetspeed.container.ContainerInfo;
import org.apache.jetspeed.container.InternalPortletContext;
import org.apache.jetspeed.dispatcher.JetspeedRequestDispatcher;
import org.apache.jetspeed.om.common.JetspeedServiceReference;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.services.JetspeedPortletServices;
import org.apache.jetspeed.services.PortletServices;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;

public class JetspeedPortletContext
implements PortletContext,
InternalPortletContext {
    public static final String LOCAL_PA_ROOT = "/WEB-INF/apps";
    private ServletContext servletContext;
    private MutablePortletApplication application;

    public JetspeedPortletContext(ServletContext servletContext, PortletApplicationDefinition application) {
        this.servletContext = servletContext;
        this.application = (MutablePortletApplication)application;
    }

    public int getMajorVersion() {
        return ContainerInfo.getMajorSpecificationVersion();
    }

    public int getMinorVersion() {
        return ContainerInfo.getMinorSpecificationVersion();
    }

    public Set getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        String localizedPath = this.localizePath(path, this.application);
        RequestDispatcher rd = this.servletContext.getRequestDispatcher(localizedPath);
        return new JetspeedRequestDispatcher(rd);
    }

    public PortletRequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcher rd = this.servletContext.getNamedDispatcher(name);
        return new JetspeedRequestDispatcher(rd);
    }

    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(this.localizePath(path, this.application));
    }

    public Object getAttribute(String name) {
        if (name.startsWith("cps:")) {
            String serviceName = name.substring("cps:".length());
            Collection validServices = this.application.getJetspeedServices();
            if (null == validServices) {
                return null;
            }
            boolean found = false;
            Iterator iterator = validServices.iterator();
            while (iterator.hasNext()) {
                JetspeedServiceReference validService = (JetspeedServiceReference)iterator.next();
                if (!validService.getName().equals(serviceName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
            PortletServices services = JetspeedPortletServices.getSingleton();
            return services.getService(serviceName);
        }
        return this.servletContext.getAttribute(name);
    }

    public void log(String msg) {
        this.servletContext.log(msg);
    }

    public void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(this.localizePath(path, this.application));
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.servletContext.getResource(this.localizePath(path, this.application));
    }

    public Enumeration getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    public String getInitParameter(String name) {
        return this.servletContext.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.setAttribute(name, object);
    }

    public String getServerInfo() {
        return ContainerInfo.getServerInfo();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public PortletApplicationDefinition getApplication() {
        return this.application;
    }

    public String getPortletContextName() {
        return this.servletContext.getServletContextName();
    }

    private String localizePath(String path, MutablePortletApplication app) {
        if (path == null) {
            return "/";
        }
        return path;
    }
}

