/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Timer;
import java.util.TimerTask;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.container.ContainerConstants;
import org.apache.jetspeed.services.JetspeedPortletServices;
import org.apache.jetspeed.services.PortletServices;
import org.apache.jetspeed.tools.pamanager.PortletApplicationManagement;
import org.apache.jetspeed.util.DirectoryHelper;
import org.apache.jetspeed.util.FileSystemHelper;

public class JetspeedContainerServlet
extends HttpServlet {
    private String contextName;
    private boolean started = false;
    private Timer startTimer = null;
    private static final String JCS = "JetspeedContainerServlet: ";
    private static final String INIT_START_MSG = "JetspeedContainerServlet: starting initialization of Portlet Application at: ";
    private static final String TRY_START_MSG = "JetspeedContainerServlet: attemping to start Portlet Application at: ";
    private static final String STARTED_MSG = "JetspeedContainerServlet: started Portlet Application at: ";
    private static final String INIT_FAILED_MSG = "JetspeedContainerServlet: initialization failed for Portlet Application at: ";
    private static final String INIT_DONE_MSG = "JetspeedContainerServlet: initialization done for Portlet Application at: ";
    private static final String STOP_MSG = "JetspeedContainerServlet: shutting down portlet application at: ";
    private static final String STOP_FAILED_MSG = "JetspeedContainerServlet: shutting down error for portlet application at: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void init(ServletConfig config) throws ServletException {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            super.init(config);
            ServletContext context = this.getServletContext();
            this.started = false;
            this.startTimer = null;
            this.contextName = config.getInitParameter("contextName");
            if (null == this.contextName || this.contextName.length() == 0) {
                this.contextName = null;
                throw new ServletException("JetspeedContainerServlet: Portlet Application contextName not supplied in Init Parameters.");
            }
            String paDir = context.getRealPath("/");
            if (paDir == null) {
                throw new ServletException("JetspeedContainerServlet:  Initialization of PortletApplication at " + this.contextName + " without access to its real path not supported");
            }
            context.log(INIT_START_MSG + this.contextName);
            System.out.println(INIT_START_MSG + this.contextName);
            try {
                this.startPortletApplication(context, paDir, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                String message = INIT_FAILED_MSG + this.contextName;
                context.log(message, (Throwable)e);
                System.err.println(message);
                throw new ServletException(message, (Throwable)e);
            }
            context.log(INIT_DONE_MSG + this.contextName);
            System.out.println(INIT_DONE_MSG + this.contextName);
        }
    }

    private void startPortletApplication(final ServletContext context, final String paDir, final ClassLoader paClassLoader) throws ServletException {
        final String START_DELAYED_MSG = "JetspeedContainerServlet: Could not yet start portlet application at: " + this.contextName + ". Starting back ground thread to start when the portal comes online.";
        context.log(START_DELAYED_MSG);
        this.startTimer = new Timer(true);
        this.startTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = JetspeedContainerServlet.this.contextName;
                synchronized (string) {
                    if (JetspeedContainerServlet.this.startTimer != null) {
                        if (JetspeedContainerServlet.this.attemptStart(context, JetspeedContainerServlet.this.contextName, paDir, paClassLoader)) {
                            JetspeedContainerServlet.this.startTimer.cancel();
                            JetspeedContainerServlet.this.startTimer = null;
                        } else {
                            context.log(START_DELAYED_MSG);
                        }
                    }
                }
            }
        }, 1L, 10000L);
    }

    private boolean attemptStart(ServletContext context, String contextPath, String paDir, ClassLoader paClassLoader) {
        try {
            PortletApplicationManagement pam;
            context.log(TRY_START_MSG + contextPath);
            PortletServices services = JetspeedPortletServices.getSingleton();
            if (services != null && (pam = (PortletApplicationManagement)services.getService("PAM")) != null) {
                DirectoryHelper paDirHelper = new DirectoryHelper(new File(paDir));
                pam.startPortletApplication(contextPath, (FileSystemHelper)paDirHelper, paClassLoader);
                this.started = true;
                context.log(STARTED_MSG + contextPath);
                return true;
            }
        }
        catch (Exception e) {
            context.log(INIT_FAILED_MSG + contextPath, (Throwable)e);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String portletName = null;
        Integer method = ContainerConstants.METHOD_NOOP;
        try {
            method = (Integer)request.getAttribute("org.apache.jetspeed.method");
            if (method == ContainerConstants.METHOD_NOOP) {
                return;
            }
            Portlet portlet = (Portlet)request.getAttribute("org.apache.jetspeed.portlet");
            request.removeAttribute("org.apache.jetspeed.portlet");
            if (method == ContainerConstants.METHOD_ACTION) {
                ActionRequest actionRequest = (ActionRequest)request.getAttribute("javax.portlet.request");
                ActionResponse actionResponse = (ActionResponse)request.getAttribute("javax.portlet.response");
                ((HttpServletRequestWrapper)((HttpServletRequestWrapper)actionRequest).getRequest()).setRequest((ServletRequest)request);
                portlet.processAction(actionRequest, actionResponse);
            } else if (method == ContainerConstants.METHOD_RENDER) {
                RenderRequest renderRequest = (RenderRequest)request.getAttribute("javax.portlet.request");
                RenderResponse renderResponse = (RenderResponse)request.getAttribute("javax.portlet.response");
                ((HttpServletRequestWrapper)((HttpServletRequestWrapper)renderRequest).getRequest()).setRequest((ServletRequest)request);
                portlet.render(renderRequest, renderResponse);
            }
            return;
        }
        catch (Throwable t) {
            ServletContext context = this.getServletContext();
            context.log("JetspeedContainerServlet: Error rendering portlet \"" + portletName + "\": " + t.toString(), t);
            try {
                String errorTemplate = this.getInitParameter("portal.error.page");
                if (errorTemplate == null) {
                    errorTemplate = "/WEB-INF/templates/generic/html/error.vm";
                }
                if (null != context.getResource(errorTemplate)) {
                    RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(errorTemplate);
                    request.setAttribute("e", (Object)t);
                    StringWriter stackTrace = new StringWriter();
                    t.printStackTrace(new PrintWriter(stackTrace));
                    request.setAttribute("stacktrace", (Object)stackTrace.toString());
                    dispatcher.include((ServletRequest)request, (ServletResponse)response);
                } else if (method != ContainerConstants.METHOD_ACTION) {
                    this.displayPortletNotAvailableMessage(t, response, portletName);
                }
            }
            catch (Throwable e) {
                this.displayPortletNotAvailableMessage(t, response, portletName);
            }
            finally {
                t.printStackTrace();
            }
            return;
        }
    }

    private void displayPortletNotAvailableMessage(Throwable t, HttpServletResponse response, String portletName) throws IOException {
        this.getServletContext().log("JetspeedContainerServlet: Error rendering JetspeedContainerServlet error page: " + t.toString(), t);
        PrintWriter directError = new PrintWriter(response.getWriter());
        directError.write("Portlet is Not Available: " + portletName + "<br/>Reason: " + t.getMessage());
        directError.close();
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.contextName != null) {
            String string = this.contextName;
            synchronized (string) {
                if (this.startTimer != null) {
                    this.startTimer.cancel();
                    this.startTimer = null;
                } else if (this.started) {
                    PortletApplicationManagement pam;
                    this.started = false;
                    PortletServices services = JetspeedPortletServices.getSingleton();
                    if (services != null && (pam = (PortletApplicationManagement)services.getService("PAM")) != null) {
                        this.getServletContext().log(STOP_MSG + this.contextName);
                        try {
                            pam.stopPortletApplication(this.contextName);
                        }
                        catch (Exception e) {
                            this.getServletContext().log(STOP_FAILED_MSG + this.contextName, (Throwable)e);
                        }
                    }
                    this.contextName = null;
                }
            }
        }
    }
}

