/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.persistence.store.Filter;
import org.apache.jetspeed.components.persistence.store.PersistenceStore;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.psml.ContentPageImpl;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.PageNotRemovedException;
import org.apache.jetspeed.page.PageNotUpdatedException;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.impl.AbstractPageManager;

public class DatabasePageManager
extends AbstractPageManager
implements PageManager {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$page$impl$DatabasePageManager == null ? (class$org$apache$jetspeed$page$impl$DatabasePageManager = DatabasePageManager.class$("org.apache.jetspeed.page.impl.DatabasePageManager")) : class$org$apache$jetspeed$page$impl$DatabasePageManager));
    private PersistenceStore persistenceStore;
    private Map pageCache = new HashMap();
    static /* synthetic */ Class class$org$apache$jetspeed$page$impl$DatabasePageManager;

    public DatabasePageManager(PersistenceStore persistenceStore, IdGenerator generator) {
        super(generator, false, false);
        this.persistenceStore = persistenceStore;
    }

    public Page getPage(String id) throws PageNotFoundException {
        if (this.pageCache.containsKey(id)) {
            return (Page)this.pageCache.get(id);
        }
        Filter filter = this.persistenceStore.newFilter();
        filter.addEqualTo("id", (Object)id);
        Object q = this.persistenceStore.newQuery(this.pageClass, filter);
        this.persistenceStore.getTransaction().begin();
        Page page = (Page)this.persistenceStore.getObjectByQuery(q);
        if (page == null) {
            throw new PageNotFoundException("Jetspeed PSML page not found: " + id);
        }
        this.pageCache.put(id, page);
        return page;
    }

    public void updatePage(Page page) throws JetspeedException, PageNotUpdatedException {
        String id;
        if (page == null) {
            log.warn((Object)"Recieved null page to update");
            return;
        }
        if (page instanceof ContentPageImpl) {
            page = ((ContentPageImpl)page).getPage();
        }
        if ((id = page.getId()) == null) {
            page.setId(this.generator.getNextPeid());
            id = page.getId();
            log.warn((Object)("Page with no Id, created new Id : " + id));
        }
        try {
            this.persistenceStore.getTransaction().begin();
            this.persistenceStore.lockForWrite((Object)page);
            this.persistenceStore.getTransaction().commit();
        }
        catch (Exception e) {
            String msg = "Unable to update Page.";
            log.error((Object)msg, (Throwable)e);
            throw new PageNotUpdatedException(msg, (Throwable)e);
        }
    }

    public void removePage(Page page) throws PageNotRemovedException {
        if (page instanceof ContentPageImpl) {
            page = ((ContentPageImpl)page).getPage();
        }
        if (this.pageCache.containsKey(page.getId())) {
            this.pageCache.remove(this.pageCache.get(page.getId()));
        }
        try {
            this.persistenceStore.getTransaction().begin();
            this.persistenceStore.deletePersistent((Object)page);
            this.persistenceStore.getTransaction().commit();
        }
        catch (Exception e) {
            String msg = "Unable to remove Page.";
            log.error((Object)msg, (Throwable)e);
            throw new PageNotRemovedException(msg, (Throwable)e);
        }
    }

    public Folder getFolder(String folderPath) {
        throw new UnsupportedOperationException("Not supported by DB impl yet");
    }

    public void updateFolder(Folder folder) throws JetspeedException {
        throw new UnsupportedOperationException("Not supported by DB impl yet");
    }

    public void removeFolder(Folder folder) throws JetspeedException {
        throw new UnsupportedOperationException("Not supported by DB impl yet");
    }

    public Link getLink(String name) throws DocumentNotFoundException {
        throw new UnsupportedOperationException("Not supported by DB impl yet");
    }

    public void updateLink(Link link) throws JetspeedException {
        throw new UnsupportedOperationException("Not supported by DB impl yet");
    }

    public void removeLink(Link link) throws JetspeedException {
        throw new UnsupportedOperationException("Not supported by DB impl yet");
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException {
        throw new UnsupportedOperationException("Not supported by DB impl yet");
    }

    public ContentPage getContentPage(String path) throws PageNotFoundException, NodeException {
        return new ContentPageImpl(this.getPage(path));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

