/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.cache.file.FileCache;
import org.apache.jetspeed.cache.file.FileCacheEntry;
import org.apache.jetspeed.cache.file.FileCacheEventListener;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Document;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.psml.ContentPageImpl;
import org.apache.jetspeed.om.page.psml.LinkImpl;
import org.apache.jetspeed.om.page.psml.PageImpl;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FolderHandler;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeSetImpl;
import org.apache.jetspeed.page.document.UnsupportedDocumentTypeException;
import org.apache.jetspeed.page.impl.AbstractPageManager;

public class CastorXmlPageManager
extends AbstractPageManager
implements PageManager,
FileCacheEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$page$impl$CastorXmlPageManager == null ? (class$org$apache$jetspeed$page$impl$CastorXmlPageManager = CastorXmlPageManager.class$("org.apache.jetspeed.page.impl.CastorXmlPageManager")) : class$org$apache$jetspeed$page$impl$CastorXmlPageManager));
    protected static final String PROFILE_PROPERTY_FOLDER_PREFIX = "_";
    protected static final String PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX = "__";
    private DocumentHandlerFactory handlerFactory;
    private FolderHandler folderHandler;
    private FileCache fileCache;
    static /* synthetic */ Class class$org$apache$jetspeed$page$impl$CastorXmlPageManager;

    public CastorXmlPageManager(IdGenerator generator, DocumentHandlerFactory handlerFactory, FolderHandler folderHandler, FileCache fileCache, boolean permissionsEnabled, boolean constraintsEnabled) throws FileNotFoundException {
        super(generator, permissionsEnabled, constraintsEnabled);
        handlerFactory.setPermissionsEnabled(permissionsEnabled);
        handlerFactory.setConstraintsEnabled(constraintsEnabled);
        this.handlerFactory = handlerFactory;
        this.folderHandler = folderHandler;
        this.fileCache = fileCache;
        this.fileCache.addListener((FileCacheEventListener)this);
    }

    public CastorXmlPageManager(IdGenerator generator, DocumentHandlerFactory handlerFactory, FolderHandler folderHandler, FileCache fileCache, boolean permissionsEnabled, boolean constraintsEnabled, List modelClasses) throws FileNotFoundException {
        super(generator, permissionsEnabled, constraintsEnabled, modelClasses);
        handlerFactory.setPermissionsEnabled(permissionsEnabled);
        handlerFactory.setConstraintsEnabled(constraintsEnabled);
        this.handlerFactory = handlerFactory;
        this.folderHandler = folderHandler;
        this.fileCache = fileCache;
        this.fileCache.addListener((FileCacheEventListener)this);
    }

    public Page getPage(String path) throws PageNotFoundException, FolderNotFoundException, NodeException {
        FolderImpl folder = this.getNodeFolder(path);
        return folder.getPage(this.getNodeName(path));
    }

    public void updatePage(Page page) throws JetspeedException {
        if (page instanceof ContentPageImpl) {
            page = ((ContentPageImpl)page).getPage();
        }
        if (page.getPath() != null) {
            if (!page.getPath().equals(page.getId())) {
                log.error((Object)"Page paths and ids must match!");
                return;
            }
        } else {
            log.error((Object)"Page paths and ids must be set!");
            return;
        }
        boolean newPage = false;
        FolderImpl parentFolder = this.getNodeFolder(page.getPath());
        if (page.getParent() == null) {
            page.setParent((Node)parentFolder);
            newPage = true;
        }
        PageImpl pageImpl = (PageImpl)page;
        pageImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
        pageImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
        page.checkAccess("edit");
        this.handlerFactory.getDocumentHandler(".psml").updateDocument((Document)page);
        if (parentFolder != null && !parentFolder.getAllNodes().contains((Node)page)) {
            parentFolder.getAllNodes().add((Node)page);
            newPage = true;
        }
        if (newPage) {
            this.notifyNewNode((Node)page);
        } else {
            this.notifyUpdatedNode((Node)page);
        }
    }

    public void removePage(Page page) throws JetspeedException {
        if (page instanceof ContentPageImpl) {
            page = ((ContentPageImpl)page).getPage();
        }
        page.checkAccess("edit");
        this.handlerFactory.getDocumentHandler(".psml").removeDocument((Document)page);
        FolderImpl folder = this.getNodeFolder(page.getPath());
        ((NodeSetImpl)folder.getAllNodes()).remove((Node)page);
        page.setParent(null);
        this.notifyRemovedNode((Node)page);
    }

    public Link getLink(String path) throws DocumentNotFoundException, UnsupportedDocumentTypeException, FolderNotFoundException, NodeException {
        FolderImpl folder = this.getNodeFolder(path);
        return folder.getLink(this.getNodeName(path));
    }

    public void updateLink(Link link) throws JetspeedException {
        if (link.getPath() != null) {
            if (!link.getPath().equals(link.getId())) {
                log.error((Object)"Link paths and ids must match!");
                return;
            }
        } else {
            log.error((Object)"Link paths and ids must be set!");
            return;
        }
        boolean newLink = false;
        FolderImpl parentFolder = this.getNodeFolder(link.getPath());
        if (link.getParent() == null) {
            link.setParent((Node)parentFolder);
            newLink = true;
        }
        LinkImpl linkImpl = (LinkImpl)link;
        linkImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
        linkImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
        link.checkAccess("edit");
        this.handlerFactory.getDocumentHandler(".link").updateDocument((Document)link);
        if (parentFolder != null && !parentFolder.getAllNodes().contains((Node)link)) {
            parentFolder.getAllNodes().add((Node)link);
            newLink = true;
        }
        if (newLink) {
            this.notifyNewNode((Node)link);
        } else {
            this.notifyUpdatedNode((Node)link);
        }
    }

    public void removeLink(Link link) throws JetspeedException {
        link.checkAccess("edit");
        this.handlerFactory.getDocumentHandler(".link").removeDocument((Document)link);
        FolderImpl folder = this.getNodeFolder(link.getPath());
        ((NodeSetImpl)folder.getAllNodes()).remove((Node)link);
        link.setParent(null);
        this.notifyRemovedNode((Node)link);
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException, UnsupportedDocumentTypeException, FolderNotFoundException, NodeException {
        FolderImpl folder = this.getNodeFolder("/");
        return folder.getPageSecurity();
    }

    public Folder getFolder(String folderPath) throws FolderNotFoundException, InvalidFolderException, NodeException {
        Folder folder = this.folderHandler.getFolder(folderPath);
        folder.checkAccess("view");
        return folder;
    }

    public void updateFolder(Folder folder) throws JetspeedException {
        if (folder.getPath() != null) {
            if (!folder.getPath().equals(folder.getId())) {
                log.error((Object)"Folder paths and ids must match!");
                return;
            }
        } else {
            log.error((Object)"Folder paths and ids must be set!");
            return;
        }
        boolean newFolder = false;
        FolderImpl parentFolder = this.getNodeFolder(folder.getPath());
        if (folder.getParent() == null) {
            folder.setParent((Node)parentFolder);
            newFolder = true;
        }
        FolderImpl folderImpl = (FolderImpl)folder;
        folderImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
        folderImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
        folder.checkAccess("edit");
        this.folderHandler.updateFolder(folder);
        if (parentFolder != null && !parentFolder.getAllNodes().contains((Node)folder)) {
            parentFolder.getAllNodes().add((Node)folder);
            newFolder = true;
        }
        if (newFolder) {
            this.notifyNewNode((Node)folder);
        } else {
            this.notifyUpdatedNode((Node)folder);
        }
    }

    public void removeFolder(Folder folder) throws JetspeedException {
        folder.checkAccess("edit");
        this.folderHandler.removeFolder(folder);
        FolderImpl parentFolder = this.getNodeFolder(folder.getPath());
        ((NodeSetImpl)parentFolder.getAllNodes()).remove((Node)folder);
        folder.setParent(null);
        this.notifyRemovedNode((Node)folder);
    }

    private FolderImpl getNodeFolder(String nodePath) throws NodeException, InvalidFolderException {
        int folderIndex = nodePath.lastIndexOf("/");
        if (folderIndex > 0) {
            return (FolderImpl)this.folderHandler.getFolder(nodePath.substring(0, folderIndex));
        }
        return (FolderImpl)this.folderHandler.getFolder("/");
    }

    private String getNodeName(String nodePath) {
        int folderIndex = nodePath.lastIndexOf("/");
        if (folderIndex > -1) {
            return nodePath.substring(folderIndex + 1);
        }
        return nodePath;
    }

    public void refresh(FileCacheEntry entry) throws Exception {
        Node refreshedNode = null;
        if (entry.getDocument() instanceof Node) {
            refreshedNode = (Node)entry.getDocument();
        }
        if (entry.getFile().exists()) {
            this.notifyUpdatedNode(refreshedNode);
        } else {
            this.notifyRemovedNode(refreshedNode);
        }
    }

    public void evict(FileCacheEntry entry) throws Exception {
    }

    public ContentPage getContentPage(String path) throws PageNotFoundException, NodeException {
        return new ContentPageImpl(this.getPage(path));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

