/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.Property;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageManagerEventListener;
import org.apache.jetspeed.page.PageNotUpdatedException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.portalsite.MenuElement;

public abstract class AbstractPageManager
implements PageManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$page$impl$AbstractPageManager == null ? (class$org$apache$jetspeed$page$impl$AbstractPageManager = AbstractPageManager.class$("org.apache.jetspeed.page.impl.AbstractPageManager")) : class$org$apache$jetspeed$page$impl$AbstractPageManager));
    protected Class fragmentClass = class$org$apache$jetspeed$om$page$psml$FragmentImpl == null ? (class$org$apache$jetspeed$om$page$psml$FragmentImpl = AbstractPageManager.class$("org.apache.jetspeed.om.page.psml.FragmentImpl")) : class$org$apache$jetspeed$om$page$psml$FragmentImpl;
    protected Class pageClass = class$org$apache$jetspeed$om$page$psml$PageImpl == null ? (class$org$apache$jetspeed$om$page$psml$PageImpl = AbstractPageManager.class$("org.apache.jetspeed.om.page.psml.PageImpl")) : class$org$apache$jetspeed$om$page$psml$PageImpl;
    protected Class folderClass = class$org$apache$jetspeed$om$folder$impl$FolderImpl == null ? (class$org$apache$jetspeed$om$folder$impl$FolderImpl = AbstractPageManager.class$("org.apache.jetspeed.om.folder.impl.FolderImpl")) : class$org$apache$jetspeed$om$folder$impl$FolderImpl;
    protected Class linkClass = class$org$apache$jetspeed$om$page$psml$LinkImpl == null ? (class$org$apache$jetspeed$om$page$psml$LinkImpl = AbstractPageManager.class$("org.apache.jetspeed.om.page.psml.LinkImpl")) : class$org$apache$jetspeed$om$page$psml$LinkImpl;
    protected Class propertyClass = class$org$apache$jetspeed$om$page$psml$PropertyImpl == null ? (class$org$apache$jetspeed$om$page$psml$PropertyImpl = AbstractPageManager.class$("org.apache.jetspeed.om.page.psml.PropertyImpl")) : class$org$apache$jetspeed$om$page$psml$PropertyImpl;
    protected Class menuDefinitionClass = class$org$apache$jetspeed$om$folder$impl$MenuDefinitionImpl == null ? (class$org$apache$jetspeed$om$folder$impl$MenuDefinitionImpl = AbstractPageManager.class$("org.apache.jetspeed.om.folder.impl.MenuDefinitionImpl")) : class$org$apache$jetspeed$om$folder$impl$MenuDefinitionImpl;
    protected Class menuExcludeDefinitionClass = class$org$apache$jetspeed$om$folder$impl$MenuExcludeDefinitionImpl == null ? (class$org$apache$jetspeed$om$folder$impl$MenuExcludeDefinitionImpl = AbstractPageManager.class$("org.apache.jetspeed.om.folder.impl.MenuExcludeDefinitionImpl")) : class$org$apache$jetspeed$om$folder$impl$MenuExcludeDefinitionImpl;
    protected Class menuIncludeDefinitionClass = class$org$apache$jetspeed$om$folder$impl$MenuIncludeDefinitionImpl == null ? (class$org$apache$jetspeed$om$folder$impl$MenuIncludeDefinitionImpl = AbstractPageManager.class$("org.apache.jetspeed.om.folder.impl.MenuIncludeDefinitionImpl")) : class$org$apache$jetspeed$om$folder$impl$MenuIncludeDefinitionImpl;
    protected Class menuOptionsDefinitionClass = class$org$apache$jetspeed$om$folder$impl$MenuOptionsDefinitionImpl == null ? (class$org$apache$jetspeed$om$folder$impl$MenuOptionsDefinitionImpl = AbstractPageManager.class$("org.apache.jetspeed.om.folder.impl.MenuOptionsDefinitionImpl")) : class$org$apache$jetspeed$om$folder$impl$MenuOptionsDefinitionImpl;
    protected Class menuSeparatorDefinitionClass = class$org$apache$jetspeed$om$folder$impl$MenuSeparatorDefinitionImpl == null ? (class$org$apache$jetspeed$om$folder$impl$MenuSeparatorDefinitionImpl = AbstractPageManager.class$("org.apache.jetspeed.om.folder.impl.MenuSeparatorDefinitionImpl")) : class$org$apache$jetspeed$om$folder$impl$MenuSeparatorDefinitionImpl;
    protected Class securityConstraintsClass = class$org$apache$jetspeed$om$page$psml$SecurityConstraintsImpl == null ? (class$org$apache$jetspeed$om$page$psml$SecurityConstraintsImpl = AbstractPageManager.class$("org.apache.jetspeed.om.page.psml.SecurityConstraintsImpl")) : class$org$apache$jetspeed$om$page$psml$SecurityConstraintsImpl;
    protected Class securityConstraintClass = class$org$apache$jetspeed$om$page$psml$SecurityConstraintImpl == null ? (class$org$apache$jetspeed$om$page$psml$SecurityConstraintImpl = AbstractPageManager.class$("org.apache.jetspeed.om.page.psml.SecurityConstraintImpl")) : class$org$apache$jetspeed$om$page$psml$SecurityConstraintImpl;
    protected IdGenerator generator = null;
    private boolean permissionsEnabled;
    private boolean constraintsEnabled;
    private List listeners = new LinkedList();
    static /* synthetic */ Class class$org$apache$jetspeed$page$impl$AbstractPageManager;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$FragmentImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$PageImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$folder$impl$FolderImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$LinkImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$PropertyImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$folder$impl$MenuDefinitionImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$folder$impl$MenuExcludeDefinitionImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$folder$impl$MenuIncludeDefinitionImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$folder$impl$MenuOptionsDefinitionImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$folder$impl$MenuSeparatorDefinitionImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$SecurityConstraintsImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$SecurityConstraintImpl;

    public AbstractPageManager(IdGenerator generator, boolean permissionsEnabled, boolean constraintsEnabled) {
        this.generator = generator;
        this.permissionsEnabled = permissionsEnabled;
        this.constraintsEnabled = constraintsEnabled;
    }

    public AbstractPageManager(IdGenerator generator, boolean permissionsEnabled, boolean constraintsEnabled, List modelClasses) {
        this.generator = generator;
        if (modelClasses.size() > 0) {
            this.fragmentClass = (Class)modelClasses.get(0);
            if (modelClasses.size() > 1) {
                this.pageClass = (Class)modelClasses.get(1);
                if (modelClasses.size() > 2) {
                    this.propertyClass = (Class)modelClasses.get(2);
                }
            }
        }
        this.permissionsEnabled = permissionsEnabled;
        this.constraintsEnabled = constraintsEnabled;
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public boolean getConstraintsEnabled() {
        return this.constraintsEnabled;
    }

    public Page newPage(String path) {
        Page page = null;
        try {
            page = (Page)this.createObject(this.pageClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".psml")) {
                path = path + ".psml";
            }
            page.setPath(path);
            page.setId(path);
            Fragment fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setId(this.generator.getNextPeid());
            fragment.setType("layout");
            page.setRootFragment(fragment);
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error((Object)message, (Throwable)e);
        }
        return page;
    }

    public Folder newFolder(String path) {
        Folder folder = null;
        try {
            folder = (Folder)this.createObject(this.folderClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            folder.setPath(path);
            folder.setId(path);
        }
        catch (ClassCastException e) {
            String message = "Failed to create link object for " + this.linkClass;
            log.error((Object)message, (Throwable)e);
        }
        return folder;
    }

    public Link newLink(String path) {
        Link link = null;
        try {
            link = (Link)this.createObject(this.linkClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".link")) {
                path = path + ".link";
            }
            link.setPath(path);
            link.setId(path);
        }
        catch (ClassCastException e) {
            String message = "Failed to create link object for " + this.linkClass;
            log.error((Object)message, (Throwable)e);
        }
        return link;
    }

    public Fragment newFragment() {
        Fragment fragment = null;
        try {
            fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setId(this.generator.getNextPeid());
            fragment.setType("layout");
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error((Object)message, (Throwable)e);
        }
        return fragment;
    }

    public Property newProperty() {
        Property property = null;
        try {
            property = (Property)this.createObject(this.propertyClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create fragment-property object for " + this.propertyClass;
            log.error((Object)message, (Throwable)e);
        }
        return property;
    }

    public MenuDefinition newMenuDefinition() {
        try {
            return (MenuDefinition)this.createObject(this.menuDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu definition object for " + this.menuDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuExcludeDefinition newMenuExcludeDefinition() {
        try {
            return (MenuExcludeDefinition)this.createObject(this.menuExcludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu exclude definition object for " + this.menuExcludeDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuIncludeDefinition newMenuIncludeDefinition() {
        try {
            return (MenuIncludeDefinition)this.createObject(this.menuIncludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu include definition object for " + this.menuIncludeDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuOptionsDefinition newMenuOptionsDefinition() {
        try {
            return (MenuOptionsDefinition)this.createObject(this.menuOptionsDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu options definition object for " + this.menuOptionsDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuSeparatorDefinition newMenuSeparatorDefinition() {
        try {
            return (MenuSeparatorDefinition)this.createObject(this.menuSeparatorDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu separator definition object for " + this.menuSeparatorDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraints newSecurityConstraints() {
        try {
            return (SecurityConstraints)this.createObject(this.securityConstraintsClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraints definition object for " + this.securityConstraintsClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.securityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.securityConstraintClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    private Object createObject(Class classe) {
        Object object = null;
        try {
            object = classe.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Factory failed to create object: " + classe.getName()), (Throwable)e);
        }
        return object;
    }

    public void addListener(PageManagerEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PageManagerEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyNewNode(Node node) {
        Iterator listenersIter = this.listeners.iterator();
        while (listenersIter.hasNext()) {
            PageManagerEventListener listener = (PageManagerEventListener)listenersIter.next();
            try {
                listener.newNode(node);
            }
            catch (Exception e) {
                log.error((Object)"Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    protected void notifyUpdatedNode(Node node) {
        Iterator listenersIter = this.listeners.iterator();
        while (listenersIter.hasNext()) {
            PageManagerEventListener listener = (PageManagerEventListener)listenersIter.next();
            try {
                listener.updatedNode(node);
            }
            catch (Exception e) {
                log.error((Object)"Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    protected void notifyRemovedNode(Node node) {
        Iterator listenersIter = this.listeners.iterator();
        while (listenersIter.hasNext()) {
            PageManagerEventListener listener = (PageManagerEventListener)listenersIter.next();
            try {
                listener.removedNode(node);
            }
            catch (Exception e) {
                log.error((Object)"Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    protected Fragment cloneFragment(Fragment source) {
        Fragment clone = this.newFragment();
        clone.setDecorator(source.getDecorator());
        clone.setName(source.getName());
        clone.setShortTitle(source.getShortTitle());
        clone.setSkin(source.getSkin());
        clone.setTitle(source.getTitle());
        clone.setType(source.getType());
        clone.setState(source.getState());
        Iterator names = source.getLayoutProperties().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            Iterator props = source.getProperties(name).iterator();
            while (props.hasNext()) {
                Property srcProp = (Property)props.next();
                Property dstProp = this.newProperty();
                dstProp.setLayout(name);
                dstProp.setName(srcProp.getName());
                dstProp.setValue(srcProp.getValue());
                clone.addProperty(dstProp);
            }
        }
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null) {
            SecurityConstraints dstSecurity = this.cloneSecurityConstraints(srcSecurity);
            clone.setSecurityConstraints(dstSecurity);
        }
        Iterator fragments = source.getFragments().iterator();
        while (fragments.hasNext()) {
            Fragment fragment = (Fragment)fragments.next();
            Fragment clonedFragment = this.cloneFragment(fragment);
            clone.getFragments().add(clonedFragment);
        }
        return clone;
    }

    public Page clonePage(Page source, String path) throws JetspeedException, PageNotUpdatedException {
        SecurityConstraints srcSecurity;
        Page page = this.newPage(path);
        page.setTitle(source.getTitle());
        page.setShortTitle(source.getShortTitle());
        page.setDefaultDecorator(source.getDefaultDecorator("layout"), "layout");
        page.setDefaultDecorator(source.getDefaultDecorator("portlet"), "portlet");
        page.setDefaultSkin(source.getDefaultSkin());
        Fragment root = this.cloneFragment(source.getRootFragment());
        page.setRootFragment(root);
        List menus = page.getMenuDefinitions();
        if (menus != null) {
            List clonedMenus = this.cloneMenuDefinitions(page.getMenuDefinitions());
            page.setMenuDefinitions(clonedMenus);
        }
        if ((srcSecurity = source.getSecurityConstraints()) != null) {
            SecurityConstraints clonedSecurity = this.cloneSecurityConstraints(srcSecurity);
            page.setSecurityConstraints(clonedSecurity);
        }
        this.updatePage(page);
        return page;
    }

    protected List cloneMenuDefinitions(List srcMenus) {
        ArrayList clonedMenus = new ArrayList(4);
        Iterator menus = srcMenus.iterator();
        while (menus.hasNext()) {
            MenuDefinition srcMenu = (MenuDefinition)menus.next();
            MenuDefinition clonedMenu = this.newMenuDefinition();
            clonedMenu.setDepth(srcMenu.getDepth());
            clonedMenu.setName(srcMenu.getName());
            clonedMenu.setOptions(srcMenu.getOptions());
            clonedMenu.setOrder(srcMenu.getOrder());
            clonedMenu.setPaths(srcMenu.isPaths());
            clonedMenu.setProfile(srcMenu.getProfile());
            clonedMenu.setRegexp(srcMenu.isRegexp());
            clonedMenu.setShortTitle(srcMenu.getShortTitle());
            clonedMenu.setSkin(srcMenu.getSkin());
            clonedMenu.setTitle(srcMenu.getTitle());
            clonedMenu.getMetadata();
            List srcElements = clonedMenu.getMenuElements();
            if (srcElements == null) continue;
            List clonedElements = this.cloneMenuElements(srcElements);
            clonedMenu.setMenuElements(clonedElements);
        }
        return clonedMenus;
    }

    protected List cloneMenuElements(List srcElements) {
        ArrayList clonedElements = new ArrayList(8);
        Iterator elements = srcElements.iterator();
        while (elements.hasNext()) {
            MenuElement srcElement = (MenuElement)elements.next();
        }
        return clonedElements;
    }

    protected SecurityConstraints cloneSecurityConstraints(SecurityConstraints source) {
        SecurityConstraints security = this.newSecurityConstraints();
        if (source.getOwner() != null) {
            security.setOwner(source.getOwner());
        }
        if (source.getSecurityConstraints() != null) {
            ArrayList<SecurityConstraint> clonedConstraints = new ArrayList<SecurityConstraint>(8);
            Iterator constraints = source.getSecurityConstraints().iterator();
            while (constraints.hasNext()) {
                SecurityConstraint srcConstraint = (SecurityConstraint)constraints.next();
                SecurityConstraint dstConstraint = this.newSecurityConstraint();
                dstConstraint.setUsers(srcConstraint.getUsers());
                dstConstraint.setRoles(srcConstraint.getRoles());
                dstConstraint.setGroups(srcConstraint.getGroups());
                dstConstraint.setPermissions(srcConstraint.getPermissions());
                clonedConstraints.add(dstConstraint);
            }
            security.setSecurityConstraints(clonedConstraints);
        }
        if (source.getSecurityConstraintsRefs() != null) {
            ArrayList<String> clonedRefs = new ArrayList<String>(8);
            Iterator refs = source.getSecurityConstraintsRefs().iterator();
            while (refs.hasNext()) {
                String constraintsRef = (String)refs.next();
                clonedRefs.add(constraintsRef);
            }
            security.setSecurityConstraintsRefs(clonedRefs);
        }
        return security;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

