/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jetspeed.page.document.DocumentHandler;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.DocumentTypeAlreadyRegisteredException;
import org.apache.jetspeed.page.document.FolderHandler;
import org.apache.jetspeed.page.document.UnsupportedDocumentTypeException;
import org.apache.jetspeed.util.ArgUtil;

public class DocumentHandlerFactoryImpl
implements DocumentHandlerFactory {
    private Map handlers;
    private FolderHandler folderHanlder;
    private boolean permissionsEnabled;
    private boolean constraintsEnabled;
    static /* synthetic */ Class class$java$util$Map;

    public DocumentHandlerFactoryImpl(Map handlers) {
        ArgUtil.assertNotNull((Class)(class$java$util$Map == null ? (class$java$util$Map = DocumentHandlerFactoryImpl.class$("java.util.Map")) : class$java$util$Map), (Object)handlers, (Object)this);
        this.handlers = handlers;
        Iterator handlersIter = handlers.values().iterator();
        while (handlersIter.hasNext()) {
            ((DocumentHandler)handlersIter.next()).setHandlerFactory((DocumentHandlerFactory)this);
        }
    }

    public DocumentHandlerFactoryImpl() {
        this(new HashMap());
    }

    public DocumentHandler getDocumentHandler(String documentType) throws UnsupportedDocumentTypeException {
        if (this.handlers.containsKey(documentType)) {
            return (DocumentHandler)this.handlers.get(documentType);
        }
        throw new UnsupportedDocumentTypeException("There are no DocumentHandlers defined for the type: " + documentType);
    }

    public void registerDocumentHandler(DocumentHandler documentHandler) throws DocumentTypeAlreadyRegisteredException {
        if (this.handlers.containsKey(documentHandler.getType())) {
            throw new DocumentTypeAlreadyRegisteredException(documentHandler.getType() + " has already been registered.");
        }
        documentHandler.setHandlerFactory((DocumentHandlerFactory)this);
        this.handlers.put(documentHandler.getType(), documentHandler);
    }

    public DocumentHandler getDocumentHandlerForPath(String documentPath) throws UnsupportedDocumentTypeException {
        int dotIndex = documentPath.indexOf(46);
        if (dotIndex > -1) {
            try {
                return this.getDocumentHandler(documentPath.substring(dotIndex));
            }
            catch (UnsupportedDocumentTypeException e) {
                int lastSlash = documentPath.lastIndexOf("/");
                if (lastSlash < 0) {
                    lastSlash = 0;
                }
                return this.getDocumentHandler(documentPath.substring(lastSlash));
            }
        }
        throw new UnsupportedDocumentTypeException("The path provided has no extension and may be a folder.");
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public void setPermissionsEnabled(boolean enabled) {
        this.permissionsEnabled = enabled;
    }

    public boolean getConstraintsEnabled() {
        return this.constraintsEnabled;
    }

    public void setConstraintsEnabled(boolean enabled) {
        this.constraintsEnabled = enabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

