/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.jetspeed.om.common.SecurityConstraint;

public class SecurityConstraintImpl
implements SecurityConstraint {
    private String users;
    private List usersList;
    private String roles;
    private List rolesList;
    private String groups;
    private List groupsList;
    private String permissions;
    private List permissionsList;

    public String getUsers() {
        return this.users;
    }

    public List getUsersList() {
        return this.usersList;
    }

    public void setUsers(String users) {
        this.users = users;
        this.usersList = SecurityConstraintImpl.parseCSVList(users);
    }

    public String getRoles() {
        return this.roles;
    }

    public List getRolesList() {
        return this.rolesList;
    }

    public void setRoles(String roles) {
        this.roles = roles;
        this.rolesList = SecurityConstraintImpl.parseCSVList(roles);
    }

    public String getGroups() {
        return this.groups;
    }

    public List getGroupsList() {
        return this.groupsList;
    }

    public void setGroups(String groups) {
        this.groups = groups;
        this.groupsList = SecurityConstraintImpl.parseCSVList(groups);
    }

    public String getPermissions() {
        return this.permissions;
    }

    public List getPermissionsList() {
        return this.permissionsList;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
        this.permissionsList = SecurityConstraintImpl.parseCSVList(permissions);
    }

    public boolean principalsMatch(List userPrincipals, List rolePrincipals, List groupPrincipals, boolean allowDefault) {
        return allowDefault && this.users == null && this.roles == null && this.groups == null || this.users != null && userPrincipals != null && (this.users.equals("*") || SecurityConstraintImpl.containsAny(this.usersList, userPrincipals)) || this.roles != null && rolePrincipals != null && (this.roles.equals("*") || SecurityConstraintImpl.containsAny(this.rolesList, rolePrincipals)) || this.groups != null && groupPrincipals != null && (this.groups.equals("*") || SecurityConstraintImpl.containsAny(this.groupsList, groupPrincipals));
    }

    public boolean actionMatch(String action) {
        return this.permissions != null && (this.permissions.equals("*") || this.permissionsList.contains(action));
    }

    public static List parseCSVList(String csv) {
        if (csv != null && !csv.equals("*")) {
            ArrayList<String> csvList = new ArrayList<String>(4);
            if (csv.indexOf(44) != -1) {
                StringTokenizer csvTokens = new StringTokenizer(csv, ",");
                while (csvTokens.hasMoreTokens()) {
                    csvList.add(csvTokens.nextToken().trim());
                }
            } else {
                csvList.add(csv);
            }
            return csvList;
        }
        return null;
    }

    public static boolean containsAny(Collection collection0, Collection collection1) {
        if (collection0 != null && collection1 != null) {
            Iterator containsIter = collection1.iterator();
            while (containsIter.hasNext()) {
                if (!collection0.contains(containsIter.next())) continue;
                return true;
            }
        }
        return false;
    }
}

