/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Defaults;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.psml.ContentFragmentImpl;
import org.apache.jetspeed.page.document.Node;

public class ContentPageImpl
implements ContentPage {
    private final Page page;
    private final Map cachedFragments;
    private ContentFragment rootContentFragment;

    public ContentPageImpl(Page page) {
        this.page = page;
        this.cachedFragments = new HashMap();
    }

    public String toString() {
        return this.page.toString();
    }

    public ContentFragment getContentFragmentById(String id) {
        ContentFragment contentFragment = null;
        if (this.cachedFragments.containsKey(id)) {
            contentFragment = (ContentFragment)this.cachedFragments.get(id);
        } else {
            Fragment f = this.page.getFragmentById(id);
            if (f != null) {
                contentFragment = new ContentFragmentImpl(f, this.cachedFragments);
                this.cachedFragments.put(id, contentFragment);
            }
        }
        return contentFragment;
    }

    public Fragment getFragmentById(String id) {
        return this.getContentFragmentById(id);
    }

    public ContentFragment getRootContentFragment() {
        if (this.rootContentFragment == null) {
            this.rootContentFragment = new ContentFragmentImpl(this.page.getRootFragment(), this.cachedFragments);
            this.cachedFragments.put(this.rootContentFragment.getId(), this.rootContentFragment);
        }
        return this.rootContentFragment;
    }

    public Fragment getRootFragment() {
        return this.getRootContentFragment();
    }

    public Object clone() throws CloneNotSupportedException {
        return new ContentPageImpl((Page)this.page.clone());
    }

    public String getDefaultDecorator(String fragmentType) {
        return this.page.getDefaultDecorator(fragmentType);
    }

    public String getDefaultSkin() {
        return this.page.getDefaultSkin();
    }

    public void setDefaultDecorator(String decoratorName, String fragmentType) {
        this.page.setDefaultDecorator(decoratorName, fragmentType);
    }

    public void setDefaultSkin(String skinName) {
        this.page.setDefaultSkin(skinName);
    }

    public void setRootFragment(Fragment fragment) {
        this.page.setRootFragment(fragment);
    }

    public List getMenuDefinitions() {
        return this.page.getMenuDefinitions();
    }

    public void setMenuDefinitions(List definitions) {
        this.page.setMenuDefinitions(definitions);
    }

    public GenericMetadata getMetadata() {
        return this.page.getMetadata();
    }

    public String getName() {
        return this.page.getName();
    }

    public Node getParent() {
        return this.page.getParent();
    }

    public String getPath() {
        return this.page.getPath();
    }

    public String getShortTitle(Locale locale) {
        return this.page.getShortTitle(locale);
    }

    public String getTitle(Locale locale) {
        return this.page.getTitle(locale);
    }

    public String getType() {
        return this.page.getType();
    }

    public String getUrl() {
        return this.page.getUrl();
    }

    public boolean isHidden() {
        return this.page.isHidden();
    }

    public void setParent(Node parent) {
        this.page.setParent(parent);
    }

    public void setPath(String path) {
        this.page.setPath(path);
    }

    public void checkAccess(String actions) throws SecurityException {
        this.page.checkAccess(actions);
    }

    public void checkConstraints(String actions) throws SecurityException {
        this.page.checkConstraints(actions);
    }

    public void checkPermissions(String actions) throws SecurityException {
        this.page.checkPermissions(actions);
    }

    public boolean getConstraintsEnabled() {
        return this.page.getConstraintsEnabled();
    }

    public boolean getPermissionsEnabled() {
        return this.page.getPermissionsEnabled();
    }

    public SecurityConstraints getSecurityConstraints() {
        return this.page.getSecurityConstraints();
    }

    public void setSecurityConstraints(SecurityConstraints constraints) {
        this.page.setSecurityConstraints(constraints);
    }

    public String getId() {
        return this.page.getId();
    }

    public String getShortTitle() {
        return this.page.getShortTitle();
    }

    public String getTitle() {
        return this.page.getTitle();
    }

    public void setId(String id) {
        this.page.setId(id);
    }

    public void setShortTitle(String title) {
        this.page.setShortTitle(title);
    }

    public void setTitle(String title) {
        this.page.setTitle(title);
    }

    public Page getPage() {
        return this.page;
    }

    public Defaults getDefaults() {
        return this.page.getDefaults();
    }
}

