/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jndi.JndiObjectLocator;
import org.springframework.jndi.JndiObjectTargetSource;

public class JndiObjectFactoryBean
extends JndiObjectLocator
implements FactoryBean {
    private Class proxyInterface;
    private boolean lookupOnStartup = true;
    private boolean cache = true;
    private Object jndiObject;

    public void setProxyInterface(Class proxyInterface) {
        if (!proxyInterface.isInterface()) {
            throw new IllegalArgumentException("[" + proxyInterface.getName() + "] is not an interface");
        }
        this.proxyInterface = proxyInterface;
    }

    public void setLookupOnStartup(boolean lookupOnStartup) {
        this.lookupOnStartup = lookupOnStartup;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        if (this.proxyInterface != null) {
            this.jndiObject = JndiObjectProxyFactory.createJndiObjectProxy(this);
        } else {
            if (!this.lookupOnStartup || !this.cache) {
                throw new IllegalArgumentException("Cannot deactivate 'lookupOnStartup' or 'cache' without specifying a 'proxyInterface'");
            }
            this.jndiObject = this.lookup();
        }
    }

    public Object getObject() {
        return this.jndiObject;
    }

    public Class getObjectType() {
        if (this.jndiObject != null) {
            return this.jndiObject.getClass();
        }
        if (this.proxyInterface != null) {
            return this.proxyInterface;
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    private static class JndiObjectProxyFactory {
        private JndiObjectProxyFactory() {
        }

        private static Object createJndiObjectProxy(JndiObjectFactoryBean jof) throws NamingException {
            JndiObjectTargetSource targetSource = new JndiObjectTargetSource();
            targetSource.setJndiTemplate(jof.getJndiTemplate());
            targetSource.setJndiName(jof.getJndiName());
            targetSource.setResourceRef(jof.isResourceRef());
            targetSource.setLookupOnStartup(jof.lookupOnStartup);
            targetSource.setCache(jof.cache);
            targetSource.afterPropertiesSet();
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.addInterface(jof.proxyInterface);
            proxyFactory.setTargetSource(targetSource);
            return proxyFactory.getProxy();
        }
    }
}

