/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ConstantException;

public class Constants {
    private final String className;
    private final Map fieldCache = new HashMap();

    public Constants(Class clazz) {
        this.className = clazz.getName();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            String name = field.getName();
            try {
                Object value = field.get(null);
                this.fieldCache.put(name, value);
                continue;
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
    }

    public int getSize() {
        return this.fieldCache.size();
    }

    public Number asNumber(String code) throws ConstantException {
        Object o = this.asObject(code);
        if (!(o instanceof Number)) {
            throw new ConstantException(this.className, code, "not a Number");
        }
        return (Number)o;
    }

    public String asString(String code) throws ConstantException {
        return this.asObject(code).toString();
    }

    public Object asObject(String code) throws ConstantException {
        Object val = this.fieldCache.get(code = code.toUpperCase());
        if (val == null) {
            throw new ConstantException(this.className, code, "not found");
        }
        return val;
    }

    public Set getValues(String namePrefix) {
        namePrefix = namePrefix.toUpperCase();
        HashSet values = new HashSet();
        Iterator it = this.fieldCache.keySet().iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            if (!code.startsWith(namePrefix)) continue;
            values.add(this.fieldCache.get(code));
        }
        return values;
    }

    public Set getValuesForProperty(String propertyName) {
        return this.getValues(this.propertyToConstantNamePrefix(propertyName));
    }

    public String toCode(Object value, String namePrefix) throws ConstantException {
        namePrefix = namePrefix.toUpperCase();
        Iterator it = this.fieldCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(namePrefix) || !entry.getValue().equals(value)) continue;
            return key;
        }
        throw new ConstantException(this.className, namePrefix, value);
    }

    public String toCodeForProperty(Object value, String propertyName) throws ConstantException {
        return this.toCode(value, this.propertyToConstantNamePrefix(propertyName));
    }

    public String propertyToConstantNamePrefix(String propertyName) {
        StringBuffer parsedPrefix = new StringBuffer();
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (Character.isUpperCase(c)) {
                parsedPrefix.append("_");
                parsedPrefix.append(c);
                continue;
            }
            parsedPrefix.append(Character.toUpperCase(c));
        }
        return parsedPrefix.toString();
    }
}

