
-----------------------------------------------------------------------------
-- SECURITY_PRINCIPAL
-----------------------------------------------------------------------------
DROP TABLE SECURITY_PRINCIPAL CASCADE;



CREATE TABLE SECURITY_PRINCIPAL
(
                                    PRINCIPAL_ID integer NOT NULL,
                                    CLASSNAME varchar (254) NOT NULL,
                                    IS_MAPPING_ONLY boolean NOT NULL,
                                    IS_ENABLED boolean NOT NULL,
                                    FULL_PATH varchar (254) NOT NULL,
                                    CREATION_DATE timestamp NOT NULL,
                                    MODIFIED_DATE timestamp NOT NULL,
    PRIMARY KEY (PRINCIPAL_ID),
    CONSTRAINT UIX_SECURITY_PRINCIPAL UNIQUE (FULL_PATH)
);


-----------------------------------------------------------------------------
-- SECURITY_PERMISSION
-----------------------------------------------------------------------------
DROP TABLE SECURITY_PERMISSION CASCADE;



CREATE TABLE SECURITY_PERMISSION
(
                                    PERMISSION_ID integer NOT NULL,
                                    CLASSNAME varchar (254) NOT NULL,
                                    NAME varchar (254) NOT NULL,
                                    ACTIONS varchar (254) NOT NULL,
                                    CREATION_DATE timestamp NOT NULL,
                                    MODIFIED_DATE timestamp NOT NULL,
    PRIMARY KEY (PERMISSION_ID)
);


-----------------------------------------------------------------------------
-- PRINCIPAL_PERMISSION
-----------------------------------------------------------------------------
DROP TABLE PRINCIPAL_PERMISSION CASCADE;



CREATE TABLE PRINCIPAL_PERMISSION
(
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    PRINCIPAL_ID integer NOT NULL,
                                      -- REFERENCES SECURITY_PERMISSION (PERMISSION_ID)
    PERMISSION_ID integer NOT NULL,
    PRIMARY KEY (PRINCIPAL_ID,PERMISSION_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_CREDENTIAL
-----------------------------------------------------------------------------
DROP TABLE SECURITY_CREDENTIAL CASCADE;



CREATE TABLE SECURITY_CREDENTIAL
(
                                    CREDENTIAL_ID integer NOT NULL,
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    PRINCIPAL_ID integer NOT NULL,
                                    VALUE varchar (254) NOT NULL,
                                    TYPE int2 NOT NULL,
                                    CLASSNAME varchar (254),
                                    UPDATE_REQUIRED boolean NOT NULL,
                                    IS_ENCODED boolean NOT NULL,
                                    IS_ENABLED boolean NOT NULL,
                                    AUTH_FAILURES int2 NOT NULL,
                                    IS_EXPIRED boolean NOT NULL,
                                    CREATION_DATE timestamp NOT NULL,
                                    MODIFIED_DATE timestamp NOT NULL,
                                    PREV_AUTH_DATE timestamp,
                                    LAST_AUTH_DATE timestamp,
                                    EXPIRATION_DATE date,
    PRIMARY KEY (CREDENTIAL_ID)
);


-----------------------------------------------------------------------------
-- SSO_SITE
-----------------------------------------------------------------------------
DROP TABLE SSO_SITE CASCADE;



CREATE TABLE SSO_SITE
(
                                    SITE_ID integer NOT NULL,
                                    NAME varchar (254) NOT NULL,
                                    URL varchar (254) NOT NULL,
                                    ALLOW_USER_SET boolean default 0,
                                    REQUIRES_CERTIFICATE boolean default 0,
    PRIMARY KEY (SITE_ID),
    CONSTRAINT UIX_SITE_URL UNIQUE (URL)
);


-----------------------------------------------------------------------------
-- SSO_SITE_TO_PRINCIPALS
-----------------------------------------------------------------------------
DROP TABLE SSO_SITE_TO_PRINCIPALS CASCADE;



CREATE TABLE SSO_SITE_TO_PRINCIPALS
(
                                      -- REFERENCES SSO_SITE (SITE_ID)
    SITE_ID integer NOT NULL,
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    PRINCIPAL_ID integer NOT NULL,
    PRIMARY KEY (SITE_ID,PRINCIPAL_ID)
);


-----------------------------------------------------------------------------
-- SSO_PRINCIPAL_TO_REMOTE
-----------------------------------------------------------------------------
DROP TABLE SSO_PRINCIPAL_TO_REMOTE CASCADE;



CREATE TABLE SSO_PRINCIPAL_TO_REMOTE
(
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    PRINCIPAL_ID integer NOT NULL,
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    REMOTE_PRINCIPAL_ID integer NOT NULL,
    PRIMARY KEY (PRINCIPAL_ID,REMOTE_PRINCIPAL_ID)
);


-----------------------------------------------------------------------------
-- SSO_SITE_TO_REMOTE
-----------------------------------------------------------------------------
DROP TABLE SSO_SITE_TO_REMOTE CASCADE;



CREATE TABLE SSO_SITE_TO_REMOTE
(
                                      -- REFERENCES SSO_SITE (SITE_ID)
    SITE_ID integer NOT NULL,
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    PRINCIPAL_ID integer NOT NULL,
    PRIMARY KEY (SITE_ID,PRINCIPAL_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_USER_ROLE
-----------------------------------------------------------------------------
DROP TABLE SECURITY_USER_ROLE CASCADE;



CREATE TABLE SECURITY_USER_ROLE
(
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    USER_ID integer NOT NULL,
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ROLE_ID integer NOT NULL,
    PRIMARY KEY (USER_ID,ROLE_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_USER_GROUP
-----------------------------------------------------------------------------
DROP TABLE SECURITY_USER_GROUP CASCADE;



CREATE TABLE SECURITY_USER_GROUP
(
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    USER_ID integer NOT NULL,
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    GROUP_ID integer NOT NULL,
    PRIMARY KEY (USER_ID,GROUP_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_GROUP_ROLE
-----------------------------------------------------------------------------
DROP TABLE SECURITY_GROUP_ROLE CASCADE;



CREATE TABLE SECURITY_GROUP_ROLE
(
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    GROUP_ID integer NOT NULL,
                                      -- REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ROLE_ID integer NOT NULL,
    PRIMARY KEY (GROUP_ID,ROLE_ID)
);


----------------------------------------------------------------------
-- SECURITY_GROUP_ROLE                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- SECURITY_PRINCIPAL                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- SECURITY_PERMISSION                                                      
----------------------------------------------------------------------

ALTER TABLE PRINCIPAL_PERMISSION
    ADD CONSTRAINT PRINCIPAL_PERMISSION_FK_1 FOREIGN KEY (PERMISSION_ID)
    REFERENCES SECURITY_PERMISSION (PERMISSION_ID)
    ON DELETE CASCADE 
;
ALTER TABLE PRINCIPAL_PERMISSION
    ADD CONSTRAINT PRINCIPAL_PERMISSION_FK_2 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- PRINCIPAL_PERMISSION                                                      
----------------------------------------------------------------------

ALTER TABLE SECURITY_CREDENTIAL
    ADD CONSTRAINT SECURITY_CREDENTIAL_FK_1 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- SECURITY_CREDENTIAL                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- SSO_SITE                                                      
----------------------------------------------------------------------

ALTER TABLE SSO_SITE_TO_PRINCIPALS
    ADD CONSTRAINT SSO_SITE_TO_PRINCIPALS_FK_1 FOREIGN KEY (SITE_ID)
    REFERENCES SSO_SITE (SITE_ID)
    ON DELETE CASCADE 
;
ALTER TABLE SSO_SITE_TO_PRINCIPALS
    ADD CONSTRAINT SSO_SITE_TO_PRINCIPALS_FK_2 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- SSO_SITE_TO_PRINCIPALS                                                      
----------------------------------------------------------------------

ALTER TABLE SSO_PRINCIPAL_TO_REMOTE
    ADD CONSTRAINT SSO_PRINCIPAL_TO_REMOTE_FK_1 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;
ALTER TABLE SSO_PRINCIPAL_TO_REMOTE
    ADD CONSTRAINT SSO_PRINCIPAL_TO_REMOTE_FK_2 FOREIGN KEY (REMOTE_PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- SSO_PRINCIPAL_TO_REMOTE                                                      
----------------------------------------------------------------------

ALTER TABLE SSO_SITE_TO_REMOTE
    ADD CONSTRAINT SSO_SITE_TO_REMOTE_FK_1 FOREIGN KEY (SITE_ID)
    REFERENCES SSO_SITE (SITE_ID)
    ON DELETE CASCADE 
;
ALTER TABLE SSO_SITE_TO_REMOTE
    ADD CONSTRAINT SSO_SITE_TO_REMOTE_FK_2 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- SSO_SITE_TO_REMOTE                                                      
----------------------------------------------------------------------

ALTER TABLE SECURITY_USER_ROLE
    ADD CONSTRAINT SECURITY_USER_ROLE_FK_1 FOREIGN KEY (ROLE_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;
ALTER TABLE SECURITY_USER_ROLE
    ADD CONSTRAINT SECURITY_USER_ROLE_FK_2 FOREIGN KEY (USER_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- SECURITY_USER_ROLE                                                      
----------------------------------------------------------------------

ALTER TABLE SECURITY_USER_GROUP
    ADD CONSTRAINT SECURITY_USER_GROUP_FK_1 FOREIGN KEY (GROUP_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;
ALTER TABLE SECURITY_USER_GROUP
    ADD CONSTRAINT SECURITY_USER_GROUP_FK_2 FOREIGN KEY (USER_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- SECURITY_USER_GROUP                                                      
----------------------------------------------------------------------

ALTER TABLE SECURITY_GROUP_ROLE
    ADD CONSTRAINT SECURITY_GROUP_ROLE_FK_1 FOREIGN KEY (GROUP_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;
ALTER TABLE SECURITY_GROUP_ROLE
    ADD CONSTRAINT SECURITY_GROUP_ROLE_FK_2 FOREIGN KEY (ROLE_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
    ON DELETE CASCADE 
;
