
-----------------------------------------------------------------------------
-- PORTLET_DEFINITION
-----------------------------------------------------------------------------
DROP TABLE PORTLET_DEFINITION CASCADE;



CREATE TABLE PORTLET_DEFINITION
(
                                    ID integer NOT NULL,
                                    NAME varchar (80),
                                    CLASS_NAME varchar (255),
                                    APPLICATION_ID integer NOT NULL,
                                    PORTLET_IDENTIFIER varchar (80),
                                    EXPIRATION_CACHE varchar (30),
                                    RESOURCE_BUNDLE varchar (255),
                                    PREFERENCE_VALIDATOR varchar (255),
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- PORTLET_APPLICATION
-----------------------------------------------------------------------------
DROP TABLE PORTLET_APPLICATION CASCADE;



CREATE TABLE PORTLET_APPLICATION
(
                                    APPLICATION_ID integer NOT NULL,
                                    APP_NAME varchar (80) NOT NULL,
                                    APP_IDENTIFIER varchar (80),
                                    VERSION varchar (80),
                                    APP_TYPE integer,
                                    CHECKSUM varchar (80),
                                    DESCRIPTION varchar (80),
                                    WEB_APP_ID integer NOT NULL,
    PRIMARY KEY (APPLICATION_ID),
    CONSTRAINT UK_APPLICATION UNIQUE (APP_NAME)
);


-----------------------------------------------------------------------------
-- WEB_APPLICATION
-----------------------------------------------------------------------------
DROP TABLE WEB_APPLICATION CASCADE;



CREATE TABLE WEB_APPLICATION
(
                                    ID integer NOT NULL,
                                    CONTEXT_ROOT varchar (255) NOT NULL,
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- PA_METADATA_FIELDS
-----------------------------------------------------------------------------
DROP TABLE PA_METADATA_FIELDS CASCADE;



CREATE TABLE PA_METADATA_FIELDS
(
                                    ID integer NOT NULL,
                                      -- REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
    OBJECT_ID integer NOT NULL,
                                    VALUE bytea NOT NULL,
                                    NAME varchar (100) NOT NULL,
                                    LOCALE_STRING varchar (50) NOT NULL,
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- PD_METADATA_FIELDS
-----------------------------------------------------------------------------
DROP TABLE PD_METADATA_FIELDS CASCADE;



CREATE TABLE PD_METADATA_FIELDS
(
                                    ID integer NOT NULL,
                                      -- REFERENCES PORTLET_DEFINITION (ID)
    OBJECT_ID integer NOT NULL,
                                    VALUE bytea NOT NULL,
                                    NAME varchar (100) NOT NULL,
                                    LOCALE_STRING varchar (50) NOT NULL,
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- LANGUAGE
-----------------------------------------------------------------------------
DROP TABLE LANGUAGE CASCADE;



CREATE TABLE LANGUAGE
(
                                    ID integer NOT NULL,
                                    PORTLET_ID integer NOT NULL,
                                    TITLE varchar (100),
                                    SHORT_TITLE varchar (50),
                                    LOCALE_STRING varchar (50) NOT NULL,
                                    KEYWORDS bytea,
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- PORTLET_CONTENT_TYPE
-----------------------------------------------------------------------------
DROP TABLE PORTLET_CONTENT_TYPE CASCADE;



CREATE TABLE PORTLET_CONTENT_TYPE
(
                                    CONTENT_TYPE_ID integer NOT NULL,
                                    PORTLET_ID integer NOT NULL,
                                    CONTENT_TYPE varchar (30) NOT NULL,
                                    MODES bytea,
    PRIMARY KEY (CONTENT_TYPE_ID)
);


-----------------------------------------------------------------------------
-- PARAMETER
-----------------------------------------------------------------------------
DROP TABLE PARAMETER CASCADE;



CREATE TABLE PARAMETER
(
                                    PARAMETER_ID integer NOT NULL,
                                    PARENT_ID integer NOT NULL,
                                    CLASS_NAME varchar (255) NOT NULL,
                                    NAME varchar (80) NOT NULL,
                                    PARAMETER_VALUE bytea NOT NULL,
    PRIMARY KEY (PARAMETER_ID)
);


-----------------------------------------------------------------------------
-- PREFERENCE_VALUE
-----------------------------------------------------------------------------
DROP TABLE PREFERENCE_VALUE CASCADE;



CREATE TABLE PREFERENCE_VALUE
(
                                    ID integer NOT NULL,
                                    PREFERENCE_ID integer,
                                    VALUE bytea,
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- PORTLET_PREFERENCE
-----------------------------------------------------------------------------
DROP TABLE PORTLET_PREFERENCE CASCADE;



CREATE TABLE PORTLET_PREFERENCE
(
                                    ID integer NOT NULL,
                                    PARENT_ID integer NOT NULL,
                                    NAME varchar (80) NOT NULL,
                                    CLASS_NAME varchar (255) NOT NULL,
                                    READ_ONLY char (1) default '1',
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- PORTLET_ENTITY
-----------------------------------------------------------------------------
DROP TABLE PORTLET_ENTITY CASCADE;



CREATE TABLE PORTLET_ENTITY
(
                                    PEID integer NOT NULL,
                                    ID varchar (255) NOT NULL,
                                    APP_NAME varchar (255) NOT NULL,
                                    PORTLET_NAME varchar (255) NOT NULL,
    PRIMARY KEY (PEID),
    CONSTRAINT UK_ENTITY_ID UNIQUE (ID)
);


-----------------------------------------------------------------------------
-- SECURITY_ROLE_REFERENCE
-----------------------------------------------------------------------------
DROP TABLE SECURITY_ROLE_REFERENCE CASCADE;



CREATE TABLE SECURITY_ROLE_REFERENCE
(
                                    ID integer NOT NULL,
                                    PORTLET_DEFINITION_ID integer NOT NULL,
                                    ROLE_NAME varchar (150) NOT NULL,
                                    ROLE_LINK varchar (150),
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- SECURITY_ROLE
-----------------------------------------------------------------------------
DROP TABLE SECURITY_ROLE CASCADE;



CREATE TABLE SECURITY_ROLE
(
                                    ID integer NOT NULL,
                                    WEB_APPLICATION_ID integer NOT NULL,
                                    ROLE_NAME varchar (150) NOT NULL,
                                    DESCRIPTION varchar (150),
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- USER_ATTRIBUTE_REF
-----------------------------------------------------------------------------
DROP TABLE USER_ATTRIBUTE_REF CASCADE;



CREATE TABLE USER_ATTRIBUTE_REF
(
                                    ID integer NOT NULL,
                                      -- REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
    APPLICATION_ID integer NOT NULL,
                                    NAME varchar (150),
                                    NAME_LINK varchar (150),
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- USER_ATTRIBUTE
-----------------------------------------------------------------------------
DROP TABLE USER_ATTRIBUTE CASCADE;



CREATE TABLE USER_ATTRIBUTE
(
                                    ID integer NOT NULL,
                                      -- REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
    APPLICATION_ID integer NOT NULL,
                                    NAME varchar (150),
                                    DESCRIPTION varchar (150),
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- JETSPEED_SERVICE
-----------------------------------------------------------------------------
DROP TABLE JETSPEED_SERVICE CASCADE;



CREATE TABLE JETSPEED_SERVICE
(
                                    ID integer NOT NULL,
                                    APPLICATION_ID integer NOT NULL,
                                    NAME varchar (150),
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- LOCALIZED_DESCRIPTION
-----------------------------------------------------------------------------
DROP TABLE LOCALIZED_DESCRIPTION CASCADE;



CREATE TABLE LOCALIZED_DESCRIPTION
(
                                    ID integer NOT NULL,
                                    OBJECT_ID integer NOT NULL,
                                    CLASS_NAME varchar (255) NOT NULL,
                                    DESCRIPTION bytea NOT NULL,
                                    LOCALE_STRING varchar (50) NOT NULL,
    PRIMARY KEY (ID)
);


-----------------------------------------------------------------------------
-- LOCALIZED_DISPLAY_NAME
-----------------------------------------------------------------------------
DROP TABLE LOCALIZED_DISPLAY_NAME CASCADE;



CREATE TABLE LOCALIZED_DISPLAY_NAME
(
                                    ID integer NOT NULL,
                                    OBJECT_ID integer NOT NULL,
                                    CLASS_NAME varchar (255),
                                    DISPLAY_NAME bytea NOT NULL,
                                    LOCALE_STRING varchar (50) NOT NULL,
    PRIMARY KEY (ID)
);


----------------------------------------------------------------------
-- LOCALIZED_DISPLAY_NAME                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PORTLET_DEFINITION                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PORTLET_APPLICATION                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- WEB_APPLICATION                                                      
----------------------------------------------------------------------

ALTER TABLE PA_METADATA_FIELDS
    ADD CONSTRAINT PA_METADATA_FIELDS_FK_1 FOREIGN KEY (OBJECT_ID)
    REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- PA_METADATA_FIELDS                                                      
----------------------------------------------------------------------

ALTER TABLE PD_METADATA_FIELDS
    ADD CONSTRAINT PD_METADATA_FIELDS_FK_1 FOREIGN KEY (OBJECT_ID)
    REFERENCES PORTLET_DEFINITION (ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- PD_METADATA_FIELDS                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- LANGUAGE                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PORTLET_CONTENT_TYPE                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PARAMETER                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PREFERENCE_VALUE                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PORTLET_PREFERENCE                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PORTLET_ENTITY                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- SECURITY_ROLE_REFERENCE                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- SECURITY_ROLE                                                      
----------------------------------------------------------------------

ALTER TABLE USER_ATTRIBUTE_REF
    ADD CONSTRAINT USER_ATTRIBUTE_REF_FK_1 FOREIGN KEY (APPLICATION_ID)
    REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- USER_ATTRIBUTE_REF                                                      
----------------------------------------------------------------------

ALTER TABLE USER_ATTRIBUTE
    ADD CONSTRAINT USER_ATTRIBUTE_FK_1 FOREIGN KEY (APPLICATION_ID)
    REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- USER_ATTRIBUTE                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- JETSPEED_SERVICE                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- LOCALIZED_DESCRIPTION                                                      
----------------------------------------------------------------------

