
-----------------------------------------------------------------------------
-- SUB_PAGES
-----------------------------------------------------------------------------
DROP TABLE SUB_PAGES CASCADE;



CREATE TABLE SUB_PAGES
(
                                    PAGE_ID varchar (80) NOT NULL,
                                    SUB_PAGE_ID varchar (80) NOT NULL
);
CREATE INDEX IX_SUB_PAGES_1 ON SUB_PAGES (PAGE_ID, SUB_PAGE_ID);


-----------------------------------------------------------------------------
-- PAGE
-----------------------------------------------------------------------------
DROP TABLE PAGE CASCADE;



CREATE TABLE PAGE
(
                                    PAGE_ID varchar (80) NOT NULL,
                                    TITLE varchar (100),
                                    DEFAULT_SKIN varchar (100),
                                    DEFAULT_DECORATOR varchar (100),
                                    DEFAULT_PORTLET_DECORATOR varchar (100),
                                    ACL varchar (80),
    PRIMARY KEY (PAGE_ID)
);


-----------------------------------------------------------------------------
-- FRAGMENT
-----------------------------------------------------------------------------
DROP TABLE FRAGMENT CASCADE;



CREATE TABLE FRAGMENT
(
                                    FRAGMENT_ID varchar (80) NOT NULL,
                                    COMPONENT_NAME varchar (100),
                                    ACL varchar (80),
                                    TITLE varchar (100),
                                    TYPE varchar (40),
                                    SKIN varchar (80),
                                    DECORATOR varchar (80),
                                    STATE varchar (40),
    PRIMARY KEY (FRAGMENT_ID)
);


-----------------------------------------------------------------------------
-- PAGE_FRAGMENTS
-----------------------------------------------------------------------------
DROP TABLE PAGE_FRAGMENTS CASCADE;



CREATE TABLE PAGE_FRAGMENTS
(
                                    PAGE_ID varchar (80) NOT NULL,
                                    FRAGMENT_ID varchar (80) NOT NULL
);
CREATE INDEX IX_PAGE_FRAGMENTS_1 ON PAGE_FRAGMENTS (PAGE_ID, FRAGMENT_ID);


-----------------------------------------------------------------------------
-- SUB_FRAGMENTS
-----------------------------------------------------------------------------
DROP TABLE SUB_FRAGMENTS CASCADE;



CREATE TABLE SUB_FRAGMENTS
(
                                    FRAGMENT_ID varchar (80) NOT NULL,
                                    SUB_FRAGMENT_ID varchar (80) NOT NULL
);
CREATE INDEX IX_SUB_FRAGMENTS_1 ON SUB_FRAGMENTS (FRAGMENT_ID, SUB_FRAGMENT_ID);


-----------------------------------------------------------------------------
-- FRAGMENT_PARAMETER
-----------------------------------------------------------------------------
DROP TABLE FRAGMENT_PARAMETER CASCADE;



CREATE TABLE FRAGMENT_PARAMETER
(
                                    PARAMETER_ID integer NOT NULL,
                                    FRAGMENT_ID integer NOT NULL,
                                    NAME varchar (80) NOT NULL,
                                    VALUE bytea NOT NULL,
    PRIMARY KEY (PARAMETER_ID),
    CONSTRAINT UN_FRAGMENT_PARAMETER_1 UNIQUE (FRAGMENT_ID, PARAMETER_ID)
);


-----------------------------------------------------------------------------
-- FRAGMENT_REF
-----------------------------------------------------------------------------
DROP TABLE FRAGMENT_REF CASCADE;



CREATE TABLE FRAGMENT_REF
(
                                    FRAGMENT_REF_ID varchar (80) NOT NULL,
                                    FRAGMENT_ID varchar (80) NOT NULL,
                                    NAME varchar (80) NOT NULL,
                                    TITLE varchar (100),
    PRIMARY KEY (FRAGMENT_REF_ID)
);


-----------------------------------------------------------------------------
-- FRAGMENT_REFS
-----------------------------------------------------------------------------
DROP TABLE FRAGMENT_REFS CASCADE;



CREATE TABLE FRAGMENT_REFS
(
                                    FRAGMENT_REF_ID varchar (80) NOT NULL,
                                    FRAGMENT_ID varchar (80) NOT NULL
);


-----------------------------------------------------------------------------
-- PROFILING_RULE
-----------------------------------------------------------------------------
DROP TABLE PROFILING_RULE CASCADE;



CREATE TABLE PROFILING_RULE
(
                                    RULE_ID varchar (80) NOT NULL,
                                    CLASS_NAME varchar (100) NOT NULL,
                                    TITLE varchar (100),
    PRIMARY KEY (RULE_ID)
);


-----------------------------------------------------------------------------
-- RULE_CRITERION
-----------------------------------------------------------------------------
DROP TABLE RULE_CRITERION CASCADE;



CREATE TABLE RULE_CRITERION
(
                                    CRITERION_ID varchar (80) NOT NULL,
                                      -- REFERENCES PROFILING_RULE (RULE_ID)
    RULE_ID varchar (80) NOT NULL,
                                    FALLBACK_ORDER integer NOT NULL,
                                    REQUEST_TYPE varchar (40) NOT NULL,
                                    NAME varchar (80) NOT NULL,
                                    VALUE varchar (128),
                                    FALLBACK_TYPE integer default 1,
    PRIMARY KEY (CRITERION_ID)
);
CREATE INDEX IX_RULE_CRITERION_1 ON RULE_CRITERION (RULE_ID, FALLBACK_ORDER);


-----------------------------------------------------------------------------
-- PRINCIPAL_RULE_ASSOC
-----------------------------------------------------------------------------
DROP TABLE PRINCIPAL_RULE_ASSOC CASCADE;



CREATE TABLE PRINCIPAL_RULE_ASSOC
(
                                    PRINCIPAL_NAME varchar (80) NOT NULL,
                                    LOCATOR_NAME varchar (80) NOT NULL,
                                    RULE_ID varchar (80) NOT NULL,
    PRIMARY KEY (PRINCIPAL_NAME,LOCATOR_NAME)
);


-----------------------------------------------------------------------------
-- PROFILE_PAGE_ASSOC
-----------------------------------------------------------------------------
DROP TABLE PROFILE_PAGE_ASSOC CASCADE;



CREATE TABLE PROFILE_PAGE_ASSOC
(
                                    LOCATOR_HASH varchar (40) NOT NULL,
                                    PAGE_ID varchar (80) NOT NULL,
    CONSTRAINT UN_PROFILE_PAGE_1 UNIQUE (LOCATOR_HASH, PAGE_ID)
);


-----------------------------------------------------------------------------
-- CLUBS
-----------------------------------------------------------------------------
DROP TABLE CLUBS CASCADE;



CREATE TABLE CLUBS
(
                                    NAME varchar (80) NOT NULL,
                                    COUNTRY varchar (40) NOT NULL,
                                    CITY varchar (40) NOT NULL,
                                    STADIUM varchar (80) NOT NULL,
                                    CAPACITY integer,
                                    FOUNDED integer,
                                    PITCH varchar (40),
                                    NICKNAME varchar (40),
    PRIMARY KEY (NAME)
);


----------------------------------------------------------------------
-- CLUBS                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- SUB_PAGES                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PAGE                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- FRAGMENT                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PAGE_FRAGMENTS                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- SUB_FRAGMENTS                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- FRAGMENT_PARAMETER                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- FRAGMENT_REF                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- FRAGMENT_REFS                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PROFILING_RULE                                                      
----------------------------------------------------------------------

ALTER TABLE RULE_CRITERION
    ADD CONSTRAINT RULE_CRITERION_FK_1 FOREIGN KEY (RULE_ID)
    REFERENCES PROFILING_RULE (RULE_ID)
    ON DELETE CASCADE 
;

----------------------------------------------------------------------
-- RULE_CRITERION                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PRINCIPAL_RULE_ASSOC                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PROFILE_PAGE_ASSOC                                                      
----------------------------------------------------------------------

