
-----------------------------------------------------------------------------
-- SECURITY_PRINCIPAL
-----------------------------------------------------------------------------
DROP TABLE SECURITY_PRINCIPAL CASCADE CONSTRAINTS;

CREATE TABLE SECURITY_PRINCIPAL
(
    PRINCIPAL_ID NUMBER NOT NULL,
    CLASSNAME VARCHAR2 (254) NOT NULL,
    IS_MAPPING_ONLY NUMBER (1, 0) NOT NULL,
    IS_ENABLED NUMBER (1, 0) NOT NULL,
    FULL_PATH VARCHAR2 (254) NOT NULL,
    CREATION_DATE DATE NOT NULL,
    MODIFIED_DATE DATE NOT NULL,
    CONSTRAINT UIX_SECURITY_PRINCIPAL UNIQUE (FULL_PATH)
);

ALTER TABLE SECURITY_PRINCIPAL
    ADD CONSTRAINT SECURITY_PRINCIPAL_PK
PRIMARY KEY (PRINCIPAL_ID);



-----------------------------------------------------------------------------
-- SECURITY_PERMISSION
-----------------------------------------------------------------------------
DROP TABLE SECURITY_PERMISSION CASCADE CONSTRAINTS;

CREATE TABLE SECURITY_PERMISSION
(
    PERMISSION_ID NUMBER NOT NULL,
    CLASSNAME VARCHAR2 (254) NOT NULL,
    NAME VARCHAR2 (254) NOT NULL,
    ACTIONS VARCHAR2 (254) NOT NULL,
    CREATION_DATE DATE NOT NULL,
    MODIFIED_DATE DATE NOT NULL
);

ALTER TABLE SECURITY_PERMISSION
    ADD CONSTRAINT SECURITY_PERMISSION_PK
PRIMARY KEY (PERMISSION_ID);



-----------------------------------------------------------------------------
-- PRINCIPAL_PERMISSION
-----------------------------------------------------------------------------
DROP TABLE PRINCIPAL_PERMISSION CASCADE CONSTRAINTS;

CREATE TABLE PRINCIPAL_PERMISSION
(
    PRINCIPAL_ID NUMBER NOT NULL,
    PERMISSION_ID NUMBER NOT NULL
);

ALTER TABLE PRINCIPAL_PERMISSION
    ADD CONSTRAINT PRINCIPAL_PERMISSION_PK
PRIMARY KEY (PRINCIPAL_ID,PERMISSION_ID);



-----------------------------------------------------------------------------
-- SECURITY_CREDENTIAL
-----------------------------------------------------------------------------
DROP TABLE SECURITY_CREDENTIAL CASCADE CONSTRAINTS;

CREATE TABLE SECURITY_CREDENTIAL
(
    CREDENTIAL_ID NUMBER NOT NULL,
    PRINCIPAL_ID NUMBER NOT NULL,
    VALUE VARCHAR2 (254) NOT NULL,
    TYPE NUMBER (5, 0) NOT NULL,
    CLASSNAME VARCHAR2 (254),
    UPDATE_REQUIRED NUMBER (1, 0) NOT NULL,
    IS_ENCODED NUMBER (1, 0) NOT NULL,
    IS_ENABLED NUMBER (1, 0) NOT NULL,
    AUTH_FAILURES NUMBER (5, 0) NOT NULL,
    IS_EXPIRED NUMBER (1, 0) NOT NULL,
    CREATION_DATE DATE NOT NULL,
    MODIFIED_DATE DATE NOT NULL,
    PREV_AUTH_DATE DATE,
    LAST_AUTH_DATE DATE,
    EXPIRATION_DATE DATE
);

ALTER TABLE SECURITY_CREDENTIAL
    ADD CONSTRAINT SECURITY_CREDENTIAL_PK
PRIMARY KEY (CREDENTIAL_ID);



-----------------------------------------------------------------------------
-- SSO_SITE
-----------------------------------------------------------------------------
DROP TABLE SSO_SITE CASCADE CONSTRAINTS;

CREATE TABLE SSO_SITE
(
    SITE_ID NUMBER NOT NULL,
    NAME VARCHAR2 (254) NOT NULL,
    URL VARCHAR2 (254) NOT NULL,
    ALLOW_USER_SET NUMBER (1, 0) default 0,
    REQUIRES_CERTIFICATE NUMBER (1, 0) default 0,
    CONSTRAINT UIX_SITE_URL UNIQUE (URL)
);

ALTER TABLE SSO_SITE
    ADD CONSTRAINT SSO_SITE_PK
PRIMARY KEY (SITE_ID);



-----------------------------------------------------------------------------
-- SSO_SITE_TO_PRINCIPALS
-----------------------------------------------------------------------------
DROP TABLE SSO_SITE_TO_PRINCIPALS CASCADE CONSTRAINTS;

CREATE TABLE SSO_SITE_TO_PRINCIPALS
(
    SITE_ID NUMBER NOT NULL,
    PRINCIPAL_ID NUMBER NOT NULL
);

ALTER TABLE SSO_SITE_TO_PRINCIPALS
    ADD CONSTRAINT SSO_SITE_TO_PRINCIPALS_PK
PRIMARY KEY (SITE_ID,PRINCIPAL_ID);



-----------------------------------------------------------------------------
-- SSO_PRINCIPAL_TO_REMOTE
-----------------------------------------------------------------------------
DROP TABLE SSO_PRINCIPAL_TO_REMOTE CASCADE CONSTRAINTS;

CREATE TABLE SSO_PRINCIPAL_TO_REMOTE
(
    PRINCIPAL_ID NUMBER NOT NULL,
    REMOTE_PRINCIPAL_ID NUMBER NOT NULL
);

ALTER TABLE SSO_PRINCIPAL_TO_REMOTE
    ADD CONSTRAINT SSO_PRINCIPAL_TO_REMOTE_PK
PRIMARY KEY (PRINCIPAL_ID,REMOTE_PRINCIPAL_ID);



-----------------------------------------------------------------------------
-- SSO_SITE_TO_REMOTE
-----------------------------------------------------------------------------
DROP TABLE SSO_SITE_TO_REMOTE CASCADE CONSTRAINTS;

CREATE TABLE SSO_SITE_TO_REMOTE
(
    SITE_ID NUMBER NOT NULL,
    PRINCIPAL_ID NUMBER NOT NULL
);

ALTER TABLE SSO_SITE_TO_REMOTE
    ADD CONSTRAINT SSO_SITE_TO_REMOTE_PK
PRIMARY KEY (SITE_ID,PRINCIPAL_ID);



-----------------------------------------------------------------------------
-- SECURITY_USER_ROLE
-----------------------------------------------------------------------------
DROP TABLE SECURITY_USER_ROLE CASCADE CONSTRAINTS;

CREATE TABLE SECURITY_USER_ROLE
(
    USER_ID NUMBER NOT NULL,
    ROLE_ID NUMBER NOT NULL
);

ALTER TABLE SECURITY_USER_ROLE
    ADD CONSTRAINT SECURITY_USER_ROLE_PK
PRIMARY KEY (USER_ID,ROLE_ID);



-----------------------------------------------------------------------------
-- SECURITY_USER_GROUP
-----------------------------------------------------------------------------
DROP TABLE SECURITY_USER_GROUP CASCADE CONSTRAINTS;

CREATE TABLE SECURITY_USER_GROUP
(
    USER_ID NUMBER NOT NULL,
    GROUP_ID NUMBER NOT NULL
);

ALTER TABLE SECURITY_USER_GROUP
    ADD CONSTRAINT SECURITY_USER_GROUP_PK
PRIMARY KEY (USER_ID,GROUP_ID);



-----------------------------------------------------------------------------
-- SECURITY_GROUP_ROLE
-----------------------------------------------------------------------------
DROP TABLE SECURITY_GROUP_ROLE CASCADE CONSTRAINTS;

CREATE TABLE SECURITY_GROUP_ROLE
(
    GROUP_ID NUMBER NOT NULL,
    ROLE_ID NUMBER NOT NULL
);

ALTER TABLE SECURITY_GROUP_ROLE
    ADD CONSTRAINT SECURITY_GROUP_ROLE_PK
PRIMARY KEY (GROUP_ID,ROLE_ID);






ALTER TABLE PRINCIPAL_PERMISSION
    ADD CONSTRAINT PRINCIPAL_PERMISSION_FK_1 FOREIGN KEY (PERMISSION_ID)
    REFERENCES SECURITY_PERMISSION (PERMISSION_ID)
ON DELETE CASCADE
;

ALTER TABLE PRINCIPAL_PERMISSION
    ADD CONSTRAINT PRINCIPAL_PERMISSION_FK_2 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;



ALTER TABLE SECURITY_CREDENTIAL
    ADD CONSTRAINT SECURITY_CREDENTIAL_FK_1 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;





ALTER TABLE SSO_SITE_TO_PRINCIPALS
    ADD CONSTRAINT SSO_SITE_TO_PRINCIPALS_FK_1 FOREIGN KEY (SITE_ID)
    REFERENCES SSO_SITE (SITE_ID)
ON DELETE CASCADE
;

ALTER TABLE SSO_SITE_TO_PRINCIPALS
    ADD CONSTRAINT SSO_SITE_TO_PRINCIPALS_FK_2 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;



ALTER TABLE SSO_PRINCIPAL_TO_REMOTE
    ADD CONSTRAINT SSO_PRINCIPAL_TO_REMOTE_FK_1 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;

ALTER TABLE SSO_PRINCIPAL_TO_REMOTE
    ADD CONSTRAINT SSO_PRINCIPAL_TO_REMOTE_FK_2 FOREIGN KEY (REMOTE_PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;



ALTER TABLE SSO_SITE_TO_REMOTE
    ADD CONSTRAINT SSO_SITE_TO_REMOTE_FK_1 FOREIGN KEY (SITE_ID)
    REFERENCES SSO_SITE (SITE_ID)
ON DELETE CASCADE
;

ALTER TABLE SSO_SITE_TO_REMOTE
    ADD CONSTRAINT SSO_SITE_TO_REMOTE_FK_2 FOREIGN KEY (PRINCIPAL_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;



ALTER TABLE SECURITY_USER_ROLE
    ADD CONSTRAINT SECURITY_USER_ROLE_FK_1 FOREIGN KEY (ROLE_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;

ALTER TABLE SECURITY_USER_ROLE
    ADD CONSTRAINT SECURITY_USER_ROLE_FK_2 FOREIGN KEY (USER_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;



ALTER TABLE SECURITY_USER_GROUP
    ADD CONSTRAINT SECURITY_USER_GROUP_FK_1 FOREIGN KEY (GROUP_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;

ALTER TABLE SECURITY_USER_GROUP
    ADD CONSTRAINT SECURITY_USER_GROUP_FK_2 FOREIGN KEY (USER_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;



ALTER TABLE SECURITY_GROUP_ROLE
    ADD CONSTRAINT SECURITY_GROUP_ROLE_FK_1 FOREIGN KEY (GROUP_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;

ALTER TABLE SECURITY_GROUP_ROLE
    ADD CONSTRAINT SECURITY_GROUP_ROLE_FK_2 FOREIGN KEY (ROLE_ID)
    REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID)
ON DELETE CASCADE
;



