
-----------------------------------------------------------------------------
-- PORTLET_DEFINITION
-----------------------------------------------------------------------------
DROP TABLE PORTLET_DEFINITION CASCADE CONSTRAINTS;

CREATE TABLE PORTLET_DEFINITION
(
    ID NUMBER NOT NULL,
    NAME VARCHAR2 (80),
    CLASS_NAME VARCHAR2 (255),
    APPLICATION_ID NUMBER NOT NULL,
    PORTLET_IDENTIFIER VARCHAR2 (80),
    EXPIRATION_CACHE VARCHAR2 (30),
    RESOURCE_BUNDLE VARCHAR2 (255),
    PREFERENCE_VALIDATOR VARCHAR2 (255)
);

ALTER TABLE PORTLET_DEFINITION
    ADD CONSTRAINT PORTLET_DEFINITION_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- PORTLET_APPLICATION
-----------------------------------------------------------------------------
DROP TABLE PORTLET_APPLICATION CASCADE CONSTRAINTS;

CREATE TABLE PORTLET_APPLICATION
(
    APPLICATION_ID NUMBER NOT NULL,
    APP_NAME VARCHAR2 (80) NOT NULL,
    APP_IDENTIFIER VARCHAR2 (80),
    VERSION VARCHAR2 (80),
    APP_TYPE NUMBER,
    CHECKSUM VARCHAR2 (80),
    DESCRIPTION VARCHAR2 (80),
    WEB_APP_ID NUMBER NOT NULL,
    CONSTRAINT UK_APPLICATION UNIQUE (APP_NAME)
);

ALTER TABLE PORTLET_APPLICATION
    ADD CONSTRAINT PORTLET_APPLICATION_PK
PRIMARY KEY (APPLICATION_ID);



-----------------------------------------------------------------------------
-- WEB_APPLICATION
-----------------------------------------------------------------------------
DROP TABLE WEB_APPLICATION CASCADE CONSTRAINTS;

CREATE TABLE WEB_APPLICATION
(
    ID NUMBER NOT NULL,
    CONTEXT_ROOT VARCHAR2 (255) NOT NULL
);

ALTER TABLE WEB_APPLICATION
    ADD CONSTRAINT WEB_APPLICATION_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- PA_METADATA_FIELDS
-----------------------------------------------------------------------------
DROP TABLE PA_METADATA_FIELDS CASCADE CONSTRAINTS;

CREATE TABLE PA_METADATA_FIELDS
(
    ID NUMBER NOT NULL,
    OBJECT_ID NUMBER NOT NULL,
    VALUE VARCHAR2 (2000) NOT NULL,
    NAME VARCHAR2 (100) NOT NULL,
    LOCALE_STRING VARCHAR2 (50) NOT NULL
);

ALTER TABLE PA_METADATA_FIELDS
    ADD CONSTRAINT PA_METADATA_FIELDS_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- PD_METADATA_FIELDS
-----------------------------------------------------------------------------
DROP TABLE PD_METADATA_FIELDS CASCADE CONSTRAINTS;

CREATE TABLE PD_METADATA_FIELDS
(
    ID NUMBER NOT NULL,
    OBJECT_ID NUMBER NOT NULL,
    VALUE VARCHAR2 (2000) NOT NULL,
    NAME VARCHAR2 (100) NOT NULL,
    LOCALE_STRING VARCHAR2 (50) NOT NULL
);

ALTER TABLE PD_METADATA_FIELDS
    ADD CONSTRAINT PD_METADATA_FIELDS_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- LANGUAGE
-----------------------------------------------------------------------------
DROP TABLE LANGUAGE CASCADE CONSTRAINTS;

CREATE TABLE LANGUAGE
(
    ID NUMBER NOT NULL,
    PORTLET_ID NUMBER NOT NULL,
    TITLE VARCHAR2 (100),
    SHORT_TITLE VARCHAR2 (50),
    LOCALE_STRING VARCHAR2 (50) NOT NULL,
    KEYWORDS VARCHAR2 (2000)
);

ALTER TABLE LANGUAGE
    ADD CONSTRAINT LANGUAGE_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- PORTLET_CONTENT_TYPE
-----------------------------------------------------------------------------
DROP TABLE PORTLET_CONTENT_TYPE CASCADE CONSTRAINTS;

CREATE TABLE PORTLET_CONTENT_TYPE
(
    CONTENT_TYPE_ID NUMBER NOT NULL,
    PORTLET_ID NUMBER NOT NULL,
    CONTENT_TYPE VARCHAR2 (30) NOT NULL,
    MODES VARCHAR2 (2000)
);

ALTER TABLE PORTLET_CONTENT_TYPE
    ADD CONSTRAINT PORTLET_CONTENT_TYPE_PK
PRIMARY KEY (CONTENT_TYPE_ID);



-----------------------------------------------------------------------------
-- PARAMETER
-----------------------------------------------------------------------------
DROP TABLE PARAMETER CASCADE CONSTRAINTS;

CREATE TABLE PARAMETER
(
    PARAMETER_ID NUMBER NOT NULL,
    PARENT_ID NUMBER NOT NULL,
    CLASS_NAME VARCHAR2 (255) NOT NULL,
    NAME VARCHAR2 (80) NOT NULL,
    PARAMETER_VALUE VARCHAR2 (2000) NOT NULL
);

ALTER TABLE PARAMETER
    ADD CONSTRAINT PARAMETER_PK
PRIMARY KEY (PARAMETER_ID);



-----------------------------------------------------------------------------
-- PREFERENCE_VALUE
-----------------------------------------------------------------------------
DROP TABLE PREFERENCE_VALUE CASCADE CONSTRAINTS;

CREATE TABLE PREFERENCE_VALUE
(
    ID NUMBER NOT NULL,
    PREFERENCE_ID NUMBER,
    VALUE VARCHAR2 (2000)
);

ALTER TABLE PREFERENCE_VALUE
    ADD CONSTRAINT PREFERENCE_VALUE_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- PORTLET_PREFERENCE
-----------------------------------------------------------------------------
DROP TABLE PORTLET_PREFERENCE CASCADE CONSTRAINTS;

CREATE TABLE PORTLET_PREFERENCE
(
    ID NUMBER NOT NULL,
    PARENT_ID NUMBER NOT NULL,
    NAME VARCHAR2 (80) NOT NULL,
    CLASS_NAME VARCHAR2 (255) NOT NULL,
    READ_ONLY CHAR (1) default '1'
);

ALTER TABLE PORTLET_PREFERENCE
    ADD CONSTRAINT PORTLET_PREFERENCE_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- PORTLET_ENTITY
-----------------------------------------------------------------------------
DROP TABLE PORTLET_ENTITY CASCADE CONSTRAINTS;

CREATE TABLE PORTLET_ENTITY
(
    PEID NUMBER NOT NULL,
    ID VARCHAR2 (255) NOT NULL,
    APP_NAME VARCHAR2 (255) NOT NULL,
    PORTLET_NAME VARCHAR2 (255) NOT NULL,
    CONSTRAINT UK_ENTITY_ID UNIQUE (ID)
);

ALTER TABLE PORTLET_ENTITY
    ADD CONSTRAINT PORTLET_ENTITY_PK
PRIMARY KEY (PEID);



-----------------------------------------------------------------------------
-- SECURITY_ROLE_REFERENCE
-----------------------------------------------------------------------------
DROP TABLE SECURITY_ROLE_REFERENCE CASCADE CONSTRAINTS;

CREATE TABLE SECURITY_ROLE_REFERENCE
(
    ID NUMBER NOT NULL,
    PORTLET_DEFINITION_ID NUMBER NOT NULL,
    ROLE_NAME VARCHAR2 (150) NOT NULL,
    ROLE_LINK VARCHAR2 (150)
);

ALTER TABLE SECURITY_ROLE_REFERENCE
    ADD CONSTRAINT SECURITY_ROLE_REFERENCE_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- SECURITY_ROLE
-----------------------------------------------------------------------------
DROP TABLE SECURITY_ROLE CASCADE CONSTRAINTS;

CREATE TABLE SECURITY_ROLE
(
    ID NUMBER NOT NULL,
    WEB_APPLICATION_ID NUMBER NOT NULL,
    ROLE_NAME VARCHAR2 (150) NOT NULL,
    DESCRIPTION VARCHAR2 (150)
);

ALTER TABLE SECURITY_ROLE
    ADD CONSTRAINT SECURITY_ROLE_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- USER_ATTRIBUTE_REF
-----------------------------------------------------------------------------
DROP TABLE USER_ATTRIBUTE_REF CASCADE CONSTRAINTS;

CREATE TABLE USER_ATTRIBUTE_REF
(
    ID NUMBER NOT NULL,
    APPLICATION_ID NUMBER NOT NULL,
    NAME VARCHAR2 (150),
    NAME_LINK VARCHAR2 (150)
);

ALTER TABLE USER_ATTRIBUTE_REF
    ADD CONSTRAINT USER_ATTRIBUTE_REF_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- USER_ATTRIBUTE
-----------------------------------------------------------------------------
DROP TABLE USER_ATTRIBUTE CASCADE CONSTRAINTS;

CREATE TABLE USER_ATTRIBUTE
(
    ID NUMBER NOT NULL,
    APPLICATION_ID NUMBER NOT NULL,
    NAME VARCHAR2 (150),
    DESCRIPTION VARCHAR2 (150)
);

ALTER TABLE USER_ATTRIBUTE
    ADD CONSTRAINT USER_ATTRIBUTE_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- JETSPEED_SERVICE
-----------------------------------------------------------------------------
DROP TABLE JETSPEED_SERVICE CASCADE CONSTRAINTS;

CREATE TABLE JETSPEED_SERVICE
(
    ID NUMBER NOT NULL,
    APPLICATION_ID NUMBER NOT NULL,
    NAME VARCHAR2 (150)
);

ALTER TABLE JETSPEED_SERVICE
    ADD CONSTRAINT JETSPEED_SERVICE_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- LOCALIZED_DESCRIPTION
-----------------------------------------------------------------------------
DROP TABLE LOCALIZED_DESCRIPTION CASCADE CONSTRAINTS;

CREATE TABLE LOCALIZED_DESCRIPTION
(
    ID NUMBER NOT NULL,
    OBJECT_ID NUMBER NOT NULL,
    CLASS_NAME VARCHAR2 (255) NOT NULL,
    DESCRIPTION VARCHAR2 (2000) NOT NULL,
    LOCALE_STRING VARCHAR2 (50) NOT NULL
);

ALTER TABLE LOCALIZED_DESCRIPTION
    ADD CONSTRAINT LOCALIZED_DESCRIPTION_PK
PRIMARY KEY (ID);



-----------------------------------------------------------------------------
-- LOCALIZED_DISPLAY_NAME
-----------------------------------------------------------------------------
DROP TABLE LOCALIZED_DISPLAY_NAME CASCADE CONSTRAINTS;

CREATE TABLE LOCALIZED_DISPLAY_NAME
(
    ID NUMBER NOT NULL,
    OBJECT_ID NUMBER NOT NULL,
    CLASS_NAME VARCHAR2 (255),
    DISPLAY_NAME VARCHAR2 (2000) NOT NULL,
    LOCALE_STRING VARCHAR2 (50) NOT NULL
);

ALTER TABLE LOCALIZED_DISPLAY_NAME
    ADD CONSTRAINT LOCALIZED_DISPLAY_NAME_PK
PRIMARY KEY (ID);








ALTER TABLE PA_METADATA_FIELDS
    ADD CONSTRAINT PA_METADATA_FIELDS_FK_1 FOREIGN KEY (OBJECT_ID)
    REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
ON DELETE CASCADE
;



ALTER TABLE PD_METADATA_FIELDS
    ADD CONSTRAINT PD_METADATA_FIELDS_FK_1 FOREIGN KEY (OBJECT_ID)
    REFERENCES PORTLET_DEFINITION (ID)
ON DELETE CASCADE
;



















ALTER TABLE USER_ATTRIBUTE_REF
    ADD CONSTRAINT USER_ATTRIBUTE_REF_FK_1 FOREIGN KEY (APPLICATION_ID)
    REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
ON DELETE CASCADE
;



ALTER TABLE USER_ATTRIBUTE
    ADD CONSTRAINT USER_ATTRIBUTE_FK_1 FOREIGN KEY (APPLICATION_ID)
    REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
ON DELETE CASCADE
;









