
-----------------------------------------------------------------------------
-- PREFS_PROPERTY_VALUE
-----------------------------------------------------------------------------
DROP TABLE PREFS_PROPERTY_VALUE CASCADE CONSTRAINTS;

CREATE TABLE PREFS_PROPERTY_VALUE
(
    PROPERTY_VALUE_ID NUMBER NOT NULL,
    NODE_ID NUMBER,
    PROPERTY_KEY_ID NUMBER,
    BOOLEAN_VALUE NUMBER (1, 0),
    DATETIME_VALUE DATE,
    LONG_VALUE NUMBER,
    DOUBLE_VALUE FLOAT,
    TEXT_VALUE VARCHAR2 (254),
    CREATION_DATE DATE,
    MODIFIED_DATE DATE
);

ALTER TABLE PREFS_PROPERTY_VALUE
    ADD CONSTRAINT PREFS_PROPERTY_VALUE_PK
PRIMARY KEY (PROPERTY_VALUE_ID);



-----------------------------------------------------------------------------
-- PREFS_NODE_PROPERTY_KEY
-----------------------------------------------------------------------------
DROP TABLE PREFS_NODE_PROPERTY_KEY CASCADE CONSTRAINTS;

CREATE TABLE PREFS_NODE_PROPERTY_KEY
(
    NODE_ID NUMBER NOT NULL,
    PROPERTY_KEY_ID NUMBER NOT NULL
);

ALTER TABLE PREFS_NODE_PROPERTY_KEY
    ADD CONSTRAINT PREFS_NODE_PROPERTY_KEY_PK
PRIMARY KEY (NODE_ID,PROPERTY_KEY_ID);



-----------------------------------------------------------------------------
-- PREFS_PROPERTY_KEY
-----------------------------------------------------------------------------
DROP TABLE PREFS_PROPERTY_KEY CASCADE CONSTRAINTS;

CREATE TABLE PREFS_PROPERTY_KEY
(
    PROPERTY_KEY_ID NUMBER NOT NULL,
    PROPERTY_NAME VARCHAR2 (100),
    PROPERTY_TYPE NUMBER (5, 0),
    CREATION_DATE DATE,
    MODIFIED_DATE DATE
);

ALTER TABLE PREFS_PROPERTY_KEY
    ADD CONSTRAINT PREFS_PROPERTY_KEY_PK
PRIMARY KEY (PROPERTY_KEY_ID);



-----------------------------------------------------------------------------
-- PREFS_NODE
-----------------------------------------------------------------------------
DROP TABLE PREFS_NODE CASCADE CONSTRAINTS;

CREATE TABLE PREFS_NODE
(
    NODE_ID NUMBER NOT NULL,
    PARENT_NODE_ID NUMBER,
    NODE_NAME VARCHAR2 (100),
    NODE_TYPE NUMBER (5, 0),
    FULL_PATH VARCHAR2 (254),
    CREATION_DATE DATE,
    MODIFIED_DATE DATE
);

ALTER TABLE PREFS_NODE
    ADD CONSTRAINT PREFS_NODE_PK
PRIMARY KEY (NODE_ID);








ALTER TABLE PREFS_NODE
    ADD CONSTRAINT PREFS_NODE_FK_1 FOREIGN KEY (PARENT_NODE_ID)
    REFERENCES PREFS_NODE (NODE_ID)
;



