
-----------------------------------------------------------------------------
-- SUB_PAGES
-----------------------------------------------------------------------------
DROP TABLE SUB_PAGES CASCADE CONSTRAINTS;

CREATE TABLE SUB_PAGES
(
    PAGE_ID VARCHAR2 (80) NOT NULL,
    SUB_PAGE_ID VARCHAR2 (80) NOT NULL
);


CREATE INDEX IX_SUB_PAGES_1 ON SUB_PAGES (PAGE_ID, SUB_PAGE_ID);


-----------------------------------------------------------------------------
-- PAGE
-----------------------------------------------------------------------------
DROP TABLE PAGE CASCADE CONSTRAINTS;

CREATE TABLE PAGE
(
    PAGE_ID VARCHAR2 (80) NOT NULL,
    TITLE VARCHAR2 (100),
    DEFAULT_SKIN VARCHAR2 (100),
    DEFAULT_DECORATOR VARCHAR2 (100),
    DEFAULT_PORTLET_DECORATOR VARCHAR2 (100),
    ACL VARCHAR2 (80)
);

ALTER TABLE PAGE
    ADD CONSTRAINT PAGE_PK
PRIMARY KEY (PAGE_ID);



-----------------------------------------------------------------------------
-- FRAGMENT
-----------------------------------------------------------------------------
DROP TABLE FRAGMENT CASCADE CONSTRAINTS;

CREATE TABLE FRAGMENT
(
    FRAGMENT_ID VARCHAR2 (80) NOT NULL,
    COMPONENT_NAME VARCHAR2 (100),
    ACL VARCHAR2 (80),
    TITLE VARCHAR2 (100),
    TYPE VARCHAR2 (40),
    SKIN VARCHAR2 (80),
    DECORATOR VARCHAR2 (80),
    STATE VARCHAR2 (40)
);

ALTER TABLE FRAGMENT
    ADD CONSTRAINT FRAGMENT_PK
PRIMARY KEY (FRAGMENT_ID);



-----------------------------------------------------------------------------
-- PAGE_FRAGMENTS
-----------------------------------------------------------------------------
DROP TABLE PAGE_FRAGMENTS CASCADE CONSTRAINTS;

CREATE TABLE PAGE_FRAGMENTS
(
    PAGE_ID VARCHAR2 (80) NOT NULL,
    FRAGMENT_ID VARCHAR2 (80) NOT NULL
);


CREATE INDEX IX_PAGE_FRAGMENTS_1 ON PAGE_FRAGMENTS (PAGE_ID, FRAGMENT_ID);


-----------------------------------------------------------------------------
-- SUB_FRAGMENTS
-----------------------------------------------------------------------------
DROP TABLE SUB_FRAGMENTS CASCADE CONSTRAINTS;

CREATE TABLE SUB_FRAGMENTS
(
    FRAGMENT_ID VARCHAR2 (80) NOT NULL,
    SUB_FRAGMENT_ID VARCHAR2 (80) NOT NULL
);


CREATE INDEX IX_SUB_FRAGMENTS_1 ON SUB_FRAGMENTS (FRAGMENT_ID, SUB_FRAGMENT_ID);


-----------------------------------------------------------------------------
-- FRAGMENT_PARAMETER
-----------------------------------------------------------------------------
DROP TABLE FRAGMENT_PARAMETER CASCADE CONSTRAINTS;

CREATE TABLE FRAGMENT_PARAMETER
(
    PARAMETER_ID NUMBER NOT NULL,
    FRAGMENT_ID NUMBER NOT NULL,
    NAME VARCHAR2 (80) NOT NULL,
    VALUE VARCHAR2 (2000) NOT NULL,
    CONSTRAINT UN_FRAGMENT_PARAMETER_1 UNIQUE (FRAGMENT_ID, PARAMETER_ID)
);

ALTER TABLE FRAGMENT_PARAMETER
    ADD CONSTRAINT FRAGMENT_PARAMETER_PK
PRIMARY KEY (PARAMETER_ID);



-----------------------------------------------------------------------------
-- FRAGMENT_REF
-----------------------------------------------------------------------------
DROP TABLE FRAGMENT_REF CASCADE CONSTRAINTS;

CREATE TABLE FRAGMENT_REF
(
    FRAGMENT_REF_ID VARCHAR2 (80) NOT NULL,
    FRAGMENT_ID VARCHAR2 (80) NOT NULL,
    NAME VARCHAR2 (80) NOT NULL,
    TITLE VARCHAR2 (100)
);

ALTER TABLE FRAGMENT_REF
    ADD CONSTRAINT FRAGMENT_REF_PK
PRIMARY KEY (FRAGMENT_REF_ID);



-----------------------------------------------------------------------------
-- FRAGMENT_REFS
-----------------------------------------------------------------------------
DROP TABLE FRAGMENT_REFS CASCADE CONSTRAINTS;

CREATE TABLE FRAGMENT_REFS
(
    FRAGMENT_REF_ID VARCHAR2 (80) NOT NULL,
    FRAGMENT_ID VARCHAR2 (80) NOT NULL
);




-----------------------------------------------------------------------------
-- PROFILING_RULE
-----------------------------------------------------------------------------
DROP TABLE PROFILING_RULE CASCADE CONSTRAINTS;

CREATE TABLE PROFILING_RULE
(
    RULE_ID VARCHAR2 (80) NOT NULL,
    CLASS_NAME VARCHAR2 (100) NOT NULL,
    TITLE VARCHAR2 (100)
);

ALTER TABLE PROFILING_RULE
    ADD CONSTRAINT PROFILING_RULE_PK
PRIMARY KEY (RULE_ID);



-----------------------------------------------------------------------------
-- RULE_CRITERION
-----------------------------------------------------------------------------
DROP TABLE RULE_CRITERION CASCADE CONSTRAINTS;

CREATE TABLE RULE_CRITERION
(
    CRITERION_ID VARCHAR2 (80) NOT NULL,
    RULE_ID VARCHAR2 (80) NOT NULL,
    FALLBACK_ORDER NUMBER NOT NULL,
    REQUEST_TYPE VARCHAR2 (40) NOT NULL,
    NAME VARCHAR2 (80) NOT NULL,
    VALUE VARCHAR2 (128),
    FALLBACK_TYPE NUMBER default 1
);

ALTER TABLE RULE_CRITERION
    ADD CONSTRAINT RULE_CRITERION_PK
PRIMARY KEY (CRITERION_ID);

CREATE INDEX IX_RULE_CRITERION_1 ON RULE_CRITERION (RULE_ID, FALLBACK_ORDER);


-----------------------------------------------------------------------------
-- PRINCIPAL_RULE_ASSOC
-----------------------------------------------------------------------------
DROP TABLE PRINCIPAL_RULE_ASSOC CASCADE CONSTRAINTS;

CREATE TABLE PRINCIPAL_RULE_ASSOC
(
    PRINCIPAL_NAME VARCHAR2 (80) NOT NULL,
    LOCATOR_NAME VARCHAR2 (80) NOT NULL,
    RULE_ID VARCHAR2 (80) NOT NULL
);

ALTER TABLE PRINCIPAL_RULE_ASSOC
    ADD CONSTRAINT PRINCIPAL_RULE_ASSOC_PK
PRIMARY KEY (PRINCIPAL_NAME,LOCATOR_NAME);



-----------------------------------------------------------------------------
-- PROFILE_PAGE_ASSOC
-----------------------------------------------------------------------------
DROP TABLE PROFILE_PAGE_ASSOC CASCADE CONSTRAINTS;

CREATE TABLE PROFILE_PAGE_ASSOC
(
    LOCATOR_HASH VARCHAR2 (40) NOT NULL,
    PAGE_ID VARCHAR2 (80) NOT NULL,
    CONSTRAINT UN_PROFILE_PAGE_1 UNIQUE (LOCATOR_HASH, PAGE_ID)
);




-----------------------------------------------------------------------------
-- CLUBS
-----------------------------------------------------------------------------
DROP TABLE CLUBS CASCADE CONSTRAINTS;

CREATE TABLE CLUBS
(
    NAME VARCHAR2 (80) NOT NULL,
    COUNTRY VARCHAR2 (40) NOT NULL,
    CITY VARCHAR2 (40) NOT NULL,
    STADIUM VARCHAR2 (80) NOT NULL,
    CAPACITY NUMBER,
    FOUNDED NUMBER,
    PITCH VARCHAR2 (40),
    NICKNAME VARCHAR2 (40)
);

ALTER TABLE CLUBS
    ADD CONSTRAINT CLUBS_PK
PRIMARY KEY (NAME);




















ALTER TABLE RULE_CRITERION
    ADD CONSTRAINT RULE_CRITERION_FK_1 FOREIGN KEY (RULE_ID)
    REFERENCES PROFILING_RULE (RULE_ID)
ON DELETE CASCADE
;









