
-----------------------------------------------------------------------------
-- MEDIA_TYPE
-----------------------------------------------------------------------------
DROP TABLE MEDIA_TYPE CASCADE CONSTRAINTS;

CREATE TABLE MEDIA_TYPE
(
    MEDIATYPE_ID NUMBER NOT NULL,
    NAME VARCHAR2 (80) NOT NULL,
    CHARACTER_SET VARCHAR2 (40),
    TITLE VARCHAR2 (80),
    DESCRIPTION VARCHAR2 (2000)
);

ALTER TABLE MEDIA_TYPE
    ADD CONSTRAINT MEDIA_TYPE_PK
PRIMARY KEY (MEDIATYPE_ID);



-----------------------------------------------------------------------------
-- CLIENT
-----------------------------------------------------------------------------
DROP TABLE CLIENT CASCADE CONSTRAINTS;

CREATE TABLE CLIENT
(
    CLIENT_ID NUMBER NOT NULL,
    NAME VARCHAR2 (80) NOT NULL,
    USER_AGENT_PATTERN VARCHAR2 (128),
    MANUFACTURER VARCHAR2 (80),
    MODEL VARCHAR2 (80),
    VERSION VARCHAR2 (40),
    PREFERRED_MIMETYPE_ID NUMBER NOT NULL
);

ALTER TABLE CLIENT
    ADD CONSTRAINT CLIENT_PK
PRIMARY KEY (CLIENT_ID);



-----------------------------------------------------------------------------
-- MIMETYPE
-----------------------------------------------------------------------------
DROP TABLE MIMETYPE CASCADE CONSTRAINTS;

CREATE TABLE MIMETYPE
(
    MIMETYPE_ID NUMBER NOT NULL,
    NAME VARCHAR2 (80) NOT NULL
);

ALTER TABLE MIMETYPE
    ADD CONSTRAINT MIMETYPE_PK
PRIMARY KEY (MIMETYPE_ID);



-----------------------------------------------------------------------------
-- CAPABILITY
-----------------------------------------------------------------------------
DROP TABLE CAPABILITY CASCADE CONSTRAINTS;

CREATE TABLE CAPABILITY
(
    CAPABILITY_ID NUMBER NOT NULL,
    CAPABILITY VARCHAR2 (80) NOT NULL
);

ALTER TABLE CAPABILITY
    ADD CONSTRAINT CAPABILITY_PK
PRIMARY KEY (CAPABILITY_ID);



-----------------------------------------------------------------------------
-- CLIENT_TO_CAPABILITY
-----------------------------------------------------------------------------
DROP TABLE CLIENT_TO_CAPABILITY CASCADE CONSTRAINTS;

CREATE TABLE CLIENT_TO_CAPABILITY
(
    CLIENT_ID NUMBER NOT NULL,
    CAPABILITY_ID NUMBER NOT NULL
);




-----------------------------------------------------------------------------
-- CLIENT_TO_MIMETYPE
-----------------------------------------------------------------------------
DROP TABLE CLIENT_TO_MIMETYPE CASCADE CONSTRAINTS;

CREATE TABLE CLIENT_TO_MIMETYPE
(
    CLIENT_ID NUMBER NOT NULL,
    MIMETYPE_ID NUMBER NOT NULL
);




-----------------------------------------------------------------------------
-- MEDIATYPE_TO_CAPABILITY
-----------------------------------------------------------------------------
DROP TABLE MEDIATYPE_TO_CAPABILITY CASCADE CONSTRAINTS;

CREATE TABLE MEDIATYPE_TO_CAPABILITY
(
    MEDIATYPE_ID NUMBER NOT NULL,
    CAPABILITY_ID NUMBER NOT NULL
);




-----------------------------------------------------------------------------
-- MEDIATYPE_TO_MIMETYPE
-----------------------------------------------------------------------------
DROP TABLE MEDIATYPE_TO_MIMETYPE CASCADE CONSTRAINTS;

CREATE TABLE MEDIATYPE_TO_MIMETYPE
(
    MEDIATYPE_ID NUMBER NOT NULL,
    MIMETYPE_ID NUMBER NOT NULL
);



















