
# -----------------------------------------------------------------------
# PORTLET_DEFINITION
# -----------------------------------------------------------------------
drop table if exists PORTLET_DEFINITION;

CREATE TABLE PORTLET_DEFINITION
(
		            ID INTEGER NOT NULL,
		            NAME VARCHAR (80),
		            CLASS_NAME VARCHAR (255),
		            APPLICATION_ID INTEGER NOT NULL,
		            PORTLET_IDENTIFIER VARCHAR (80),
		            EXPIRATION_CACHE VARCHAR (30),
		            RESOURCE_BUNDLE VARCHAR (255),
		            PREFERENCE_VALIDATOR VARCHAR (255),
    PRIMARY KEY(ID)
);

# -----------------------------------------------------------------------
# PORTLET_APPLICATION
# -----------------------------------------------------------------------
drop table if exists PORTLET_APPLICATION;

CREATE TABLE PORTLET_APPLICATION
(
		            APPLICATION_ID INTEGER NOT NULL,
		            APP_NAME VARCHAR (80) NOT NULL,
		            APP_IDENTIFIER VARCHAR (80),
		            VERSION VARCHAR (80),
		            APP_TYPE INTEGER,
		            CHECKSUM VARCHAR (80),
		            DESCRIPTION VARCHAR (80),
		            WEB_APP_ID INTEGER NOT NULL,
    PRIMARY KEY(APPLICATION_ID),
    UNIQUE (APP_NAME)
);

# -----------------------------------------------------------------------
# WEB_APPLICATION
# -----------------------------------------------------------------------
drop table if exists WEB_APPLICATION;

CREATE TABLE WEB_APPLICATION
(
		            ID INTEGER NOT NULL,
		            CONTEXT_ROOT VARCHAR (255) NOT NULL,
    PRIMARY KEY(ID)
);

# -----------------------------------------------------------------------
# PA_METADATA_FIELDS
# -----------------------------------------------------------------------
drop table if exists PA_METADATA_FIELDS;

CREATE TABLE PA_METADATA_FIELDS
(
		            ID INTEGER NOT NULL,
		            OBJECT_ID INTEGER NOT NULL,
		            VALUE MEDIUMTEXT NOT NULL,
		            NAME VARCHAR (100) NOT NULL,
		            LOCALE_STRING VARCHAR (50) NOT NULL,
    PRIMARY KEY(ID),
    FOREIGN KEY (OBJECT_ID) REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
        ON DELETE CASCADE 
  
);

# -----------------------------------------------------------------------
# PD_METADATA_FIELDS
# -----------------------------------------------------------------------
drop table if exists PD_METADATA_FIELDS;

CREATE TABLE PD_METADATA_FIELDS
(
		            ID INTEGER NOT NULL,
		            OBJECT_ID INTEGER NOT NULL,
		            VALUE MEDIUMTEXT NOT NULL,
		            NAME VARCHAR (100) NOT NULL,
		            LOCALE_STRING VARCHAR (50) NOT NULL,
    PRIMARY KEY(ID),
    FOREIGN KEY (OBJECT_ID) REFERENCES PORTLET_DEFINITION (ID)
        ON DELETE CASCADE 
  
);

# -----------------------------------------------------------------------
# LANGUAGE
# -----------------------------------------------------------------------
drop table if exists LANGUAGE;

CREATE TABLE LANGUAGE
(
		            ID INTEGER NOT NULL,
		            PORTLET_ID INTEGER NOT NULL,
		            TITLE VARCHAR (100),
		            SHORT_TITLE VARCHAR (50),
		            LOCALE_STRING VARCHAR (50) NOT NULL,
		            KEYWORDS MEDIUMTEXT,
    PRIMARY KEY(ID)
);

# -----------------------------------------------------------------------
# PORTLET_CONTENT_TYPE
# -----------------------------------------------------------------------
drop table if exists PORTLET_CONTENT_TYPE;

CREATE TABLE PORTLET_CONTENT_TYPE
(
		            CONTENT_TYPE_ID INTEGER NOT NULL,
		            PORTLET_ID INTEGER NOT NULL,
		            CONTENT_TYPE VARCHAR (30) NOT NULL,
		            MODES MEDIUMTEXT,
    PRIMARY KEY(CONTENT_TYPE_ID)
);

# -----------------------------------------------------------------------
# PARAMETER
# -----------------------------------------------------------------------
drop table if exists PARAMETER;

CREATE TABLE PARAMETER
(
		            PARAMETER_ID INTEGER NOT NULL,
		            PARENT_ID INTEGER NOT NULL,
		            CLASS_NAME VARCHAR (255) NOT NULL,
		            NAME VARCHAR (80) NOT NULL,
		            PARAMETER_VALUE MEDIUMTEXT NOT NULL,
    PRIMARY KEY(PARAMETER_ID)
);

# -----------------------------------------------------------------------
# PREFERENCE_VALUE
# -----------------------------------------------------------------------
drop table if exists PREFERENCE_VALUE;

CREATE TABLE PREFERENCE_VALUE
(
		            ID INTEGER NOT NULL,
		            PREFERENCE_ID INTEGER,
		            VALUE MEDIUMTEXT,
    PRIMARY KEY(ID)
);

# -----------------------------------------------------------------------
# PORTLET_PREFERENCE
# -----------------------------------------------------------------------
drop table if exists PORTLET_PREFERENCE;

CREATE TABLE PORTLET_PREFERENCE
(
		            ID INTEGER NOT NULL,
		            PARENT_ID INTEGER NOT NULL,
		            NAME VARCHAR (80) NOT NULL,
		            CLASS_NAME VARCHAR (255) NOT NULL,
		            READ_ONLY CHAR (1) default '1',
    PRIMARY KEY(ID)
);

# -----------------------------------------------------------------------
# PORTLET_ENTITY
# -----------------------------------------------------------------------
drop table if exists PORTLET_ENTITY;

CREATE TABLE PORTLET_ENTITY
(
		            PEID INTEGER NOT NULL,
		            ID VARCHAR (255) NOT NULL,
		            APP_NAME VARCHAR (255) NOT NULL,
		            PORTLET_NAME VARCHAR (255) NOT NULL,
    PRIMARY KEY(PEID),
    UNIQUE (ID)
);

# -----------------------------------------------------------------------
# SECURITY_ROLE_REFERENCE
# -----------------------------------------------------------------------
drop table if exists SECURITY_ROLE_REFERENCE;

CREATE TABLE SECURITY_ROLE_REFERENCE
(
		            ID INTEGER NOT NULL,
		            PORTLET_DEFINITION_ID INTEGER NOT NULL,
		            ROLE_NAME VARCHAR (150) NOT NULL,
		            ROLE_LINK VARCHAR (150),
    PRIMARY KEY(ID)
);

# -----------------------------------------------------------------------
# SECURITY_ROLE
# -----------------------------------------------------------------------
drop table if exists SECURITY_ROLE;

CREATE TABLE SECURITY_ROLE
(
		            ID INTEGER NOT NULL,
		            WEB_APPLICATION_ID INTEGER NOT NULL,
		            ROLE_NAME VARCHAR (150) NOT NULL,
		            DESCRIPTION VARCHAR (150),
    PRIMARY KEY(ID)
);

# -----------------------------------------------------------------------
# USER_ATTRIBUTE_REF
# -----------------------------------------------------------------------
drop table if exists USER_ATTRIBUTE_REF;

CREATE TABLE USER_ATTRIBUTE_REF
(
		            ID INTEGER NOT NULL,
		            APPLICATION_ID INTEGER NOT NULL,
		            NAME VARCHAR (150),
		            NAME_LINK VARCHAR (150),
    PRIMARY KEY(ID),
    FOREIGN KEY (APPLICATION_ID) REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
        ON DELETE CASCADE 
  
);

# -----------------------------------------------------------------------
# USER_ATTRIBUTE
# -----------------------------------------------------------------------
drop table if exists USER_ATTRIBUTE;

CREATE TABLE USER_ATTRIBUTE
(
		            ID INTEGER NOT NULL,
		            APPLICATION_ID INTEGER NOT NULL,
		            NAME VARCHAR (150),
		            DESCRIPTION VARCHAR (150),
    PRIMARY KEY(ID),
    FOREIGN KEY (APPLICATION_ID) REFERENCES PORTLET_APPLICATION (APPLICATION_ID)
        ON DELETE CASCADE 
  
);

# -----------------------------------------------------------------------
# JETSPEED_SERVICE
# -----------------------------------------------------------------------
drop table if exists JETSPEED_SERVICE;

CREATE TABLE JETSPEED_SERVICE
(
		            ID INTEGER NOT NULL,
		            APPLICATION_ID INTEGER NOT NULL,
		            NAME VARCHAR (150),
    PRIMARY KEY(ID)
);

# -----------------------------------------------------------------------
# LOCALIZED_DESCRIPTION
# -----------------------------------------------------------------------
drop table if exists LOCALIZED_DESCRIPTION;

CREATE TABLE LOCALIZED_DESCRIPTION
(
		            ID INTEGER NOT NULL,
		            OBJECT_ID INTEGER NOT NULL,
		            CLASS_NAME VARCHAR (255) NOT NULL,
		            DESCRIPTION MEDIUMTEXT NOT NULL,
		            LOCALE_STRING VARCHAR (50) NOT NULL,
    PRIMARY KEY(ID)
);

# -----------------------------------------------------------------------
# LOCALIZED_DISPLAY_NAME
# -----------------------------------------------------------------------
drop table if exists LOCALIZED_DISPLAY_NAME;

CREATE TABLE LOCALIZED_DISPLAY_NAME
(
		            ID INTEGER NOT NULL,
		            OBJECT_ID INTEGER NOT NULL,
		            CLASS_NAME VARCHAR (255),
		            DISPLAY_NAME MEDIUMTEXT NOT NULL,
		            LOCALE_STRING VARCHAR (50) NOT NULL,
    PRIMARY KEY(ID)
);
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
