
# -----------------------------------------------------------------------
# SUB_PAGES
# -----------------------------------------------------------------------
drop table if exists SUB_PAGES;

CREATE TABLE SUB_PAGES
(
		            PAGE_ID VARCHAR (80) NOT NULL,
		            SUB_PAGE_ID VARCHAR (80) NOT NULL,
    INDEX IX_SUB_PAGES_1 (PAGE_ID, SUB_PAGE_ID)
);

# -----------------------------------------------------------------------
# PAGE
# -----------------------------------------------------------------------
drop table if exists PAGE;

CREATE TABLE PAGE
(
		            PAGE_ID VARCHAR (80) NOT NULL,
		            TITLE VARCHAR (100),
		            DEFAULT_SKIN VARCHAR (100),
		            DEFAULT_DECORATOR VARCHAR (100),
		            DEFAULT_PORTLET_DECORATOR VARCHAR (100),
		            ACL VARCHAR (80),
    PRIMARY KEY(PAGE_ID)
);

# -----------------------------------------------------------------------
# FRAGMENT
# -----------------------------------------------------------------------
drop table if exists FRAGMENT;

CREATE TABLE FRAGMENT
(
		            FRAGMENT_ID VARCHAR (80) NOT NULL,
		            COMPONENT_NAME VARCHAR (100),
		            ACL VARCHAR (80),
		            TITLE VARCHAR (100),
		            TYPE VARCHAR (40),
		            SKIN VARCHAR (80),
		            DECORATOR VARCHAR (80),
		            STATE VARCHAR (40),
    PRIMARY KEY(FRAGMENT_ID)
);

# -----------------------------------------------------------------------
# PAGE_FRAGMENTS
# -----------------------------------------------------------------------
drop table if exists PAGE_FRAGMENTS;

CREATE TABLE PAGE_FRAGMENTS
(
		            PAGE_ID VARCHAR (80) NOT NULL,
		            FRAGMENT_ID VARCHAR (80) NOT NULL,
    INDEX IX_PAGE_FRAGMENTS_1 (PAGE_ID, FRAGMENT_ID)
);

# -----------------------------------------------------------------------
# SUB_FRAGMENTS
# -----------------------------------------------------------------------
drop table if exists SUB_FRAGMENTS;

CREATE TABLE SUB_FRAGMENTS
(
		            FRAGMENT_ID VARCHAR (80) NOT NULL,
		            SUB_FRAGMENT_ID VARCHAR (80) NOT NULL,
    INDEX IX_SUB_FRAGMENTS_1 (FRAGMENT_ID, SUB_FRAGMENT_ID)
);

# -----------------------------------------------------------------------
# FRAGMENT_PARAMETER
# -----------------------------------------------------------------------
drop table if exists FRAGMENT_PARAMETER;

CREATE TABLE FRAGMENT_PARAMETER
(
		            PARAMETER_ID INTEGER NOT NULL,
		            FRAGMENT_ID INTEGER NOT NULL,
		            NAME VARCHAR (80) NOT NULL,
		            VALUE MEDIUMTEXT NOT NULL,
    PRIMARY KEY(PARAMETER_ID),
    UNIQUE (FRAGMENT_ID, PARAMETER_ID)
);

# -----------------------------------------------------------------------
# FRAGMENT_REF
# -----------------------------------------------------------------------
drop table if exists FRAGMENT_REF;

CREATE TABLE FRAGMENT_REF
(
		            FRAGMENT_REF_ID VARCHAR (80) NOT NULL,
		            FRAGMENT_ID VARCHAR (80) NOT NULL,
		            NAME VARCHAR (80) NOT NULL,
		            TITLE VARCHAR (100),
    PRIMARY KEY(FRAGMENT_REF_ID)
);

# -----------------------------------------------------------------------
# FRAGMENT_REFS
# -----------------------------------------------------------------------
drop table if exists FRAGMENT_REFS;

CREATE TABLE FRAGMENT_REFS
(
		            FRAGMENT_REF_ID VARCHAR (80) NOT NULL,
		            FRAGMENT_ID VARCHAR (80) NOT NULL
);

# -----------------------------------------------------------------------
# PROFILING_RULE
# -----------------------------------------------------------------------
drop table if exists PROFILING_RULE;

CREATE TABLE PROFILING_RULE
(
		            RULE_ID VARCHAR (80) NOT NULL,
		            CLASS_NAME VARCHAR (100) NOT NULL,
		            TITLE VARCHAR (100),
    PRIMARY KEY(RULE_ID)
);

# -----------------------------------------------------------------------
# RULE_CRITERION
# -----------------------------------------------------------------------
drop table if exists RULE_CRITERION;

CREATE TABLE RULE_CRITERION
(
		            CRITERION_ID VARCHAR (80) NOT NULL,
		            RULE_ID VARCHAR (80) NOT NULL,
		            FALLBACK_ORDER INTEGER NOT NULL,
		            REQUEST_TYPE VARCHAR (40) NOT NULL,
		            NAME VARCHAR (80) NOT NULL,
		            VALUE VARCHAR (128),
		            FALLBACK_TYPE INTEGER default 1,
    PRIMARY KEY(CRITERION_ID),
    FOREIGN KEY (RULE_ID) REFERENCES PROFILING_RULE (RULE_ID)
        ON DELETE CASCADE 
  ,
    INDEX IX_RULE_CRITERION_1 (RULE_ID, FALLBACK_ORDER)
);

# -----------------------------------------------------------------------
# PRINCIPAL_RULE_ASSOC
# -----------------------------------------------------------------------
drop table if exists PRINCIPAL_RULE_ASSOC;

CREATE TABLE PRINCIPAL_RULE_ASSOC
(
		            PRINCIPAL_NAME VARCHAR (80) NOT NULL,
		            LOCATOR_NAME VARCHAR (80) NOT NULL,
		            RULE_ID VARCHAR (80) NOT NULL,
    PRIMARY KEY(PRINCIPAL_NAME,LOCATOR_NAME)
);

# -----------------------------------------------------------------------
# PROFILE_PAGE_ASSOC
# -----------------------------------------------------------------------
drop table if exists PROFILE_PAGE_ASSOC;

CREATE TABLE PROFILE_PAGE_ASSOC
(
		            LOCATOR_HASH VARCHAR (40) NOT NULL,
		            PAGE_ID VARCHAR (80) NOT NULL,
    UNIQUE (LOCATOR_HASH, PAGE_ID)
);

# -----------------------------------------------------------------------
# CLUBS
# -----------------------------------------------------------------------
drop table if exists CLUBS;

CREATE TABLE CLUBS
(
		            NAME VARCHAR (80) NOT NULL,
		            COUNTRY VARCHAR (40) NOT NULL,
		            CITY VARCHAR (40) NOT NULL,
		            STADIUM VARCHAR (80) NOT NULL,
		            CAPACITY INTEGER,
		            FOUNDED INTEGER,
		            PITCH VARCHAR (40),
		            NICKNAME VARCHAR (40),
    PRIMARY KEY(NAME)
);
  
  
  
  
  
  
  
  
  
  
  
  
  
