
# -----------------------------------------------------------------------
# MEDIA_TYPE
# -----------------------------------------------------------------------
drop table if exists MEDIA_TYPE;

CREATE TABLE MEDIA_TYPE
(
		            MEDIATYPE_ID INTEGER NOT NULL,
		            NAME VARCHAR (80) NOT NULL,
		            CHARACTER_SET VARCHAR (40),
		            TITLE VARCHAR (80),
		            DESCRIPTION MEDIUMTEXT,
    PRIMARY KEY(MEDIATYPE_ID)
);

# -----------------------------------------------------------------------
# CLIENT
# -----------------------------------------------------------------------
drop table if exists CLIENT;

CREATE TABLE CLIENT
(
		            CLIENT_ID INTEGER NOT NULL,
		            NAME VARCHAR (80) NOT NULL,
		            USER_AGENT_PATTERN VARCHAR (128),
		            MANUFACTURER VARCHAR (80),
		            MODEL VARCHAR (80),
		            VERSION VARCHAR (40),
		            PREFERRED_MIMETYPE_ID INTEGER NOT NULL,
    PRIMARY KEY(CLIENT_ID)
);

# -----------------------------------------------------------------------
# MIMETYPE
# -----------------------------------------------------------------------
drop table if exists MIMETYPE;

CREATE TABLE MIMETYPE
(
		            MIMETYPE_ID INTEGER NOT NULL,
		            NAME VARCHAR (80) NOT NULL,
    PRIMARY KEY(MIMETYPE_ID)
);

# -----------------------------------------------------------------------
# CAPABILITY
# -----------------------------------------------------------------------
drop table if exists CAPABILITY;

CREATE TABLE CAPABILITY
(
		            CAPABILITY_ID INTEGER NOT NULL,
		            CAPABILITY VARCHAR (80) NOT NULL,
    PRIMARY KEY(CAPABILITY_ID)
);

# -----------------------------------------------------------------------
# CLIENT_TO_CAPABILITY
# -----------------------------------------------------------------------
drop table if exists CLIENT_TO_CAPABILITY;

CREATE TABLE CLIENT_TO_CAPABILITY
(
		            CLIENT_ID INTEGER NOT NULL,
		            CAPABILITY_ID INTEGER NOT NULL
);

# -----------------------------------------------------------------------
# CLIENT_TO_MIMETYPE
# -----------------------------------------------------------------------
drop table if exists CLIENT_TO_MIMETYPE;

CREATE TABLE CLIENT_TO_MIMETYPE
(
		            CLIENT_ID INTEGER NOT NULL,
		            MIMETYPE_ID INTEGER NOT NULL
);

# -----------------------------------------------------------------------
# MEDIATYPE_TO_CAPABILITY
# -----------------------------------------------------------------------
drop table if exists MEDIATYPE_TO_CAPABILITY;

CREATE TABLE MEDIATYPE_TO_CAPABILITY
(
		            MEDIATYPE_ID INTEGER NOT NULL,
		            CAPABILITY_ID INTEGER NOT NULL
);

# -----------------------------------------------------------------------
# MEDIATYPE_TO_MIMETYPE
# -----------------------------------------------------------------------
drop table if exists MEDIATYPE_TO_MIMETYPE;

CREATE TABLE MEDIATYPE_TO_MIMETYPE
(
		            MEDIATYPE_ID INTEGER NOT NULL,
		            MIMETYPE_ID INTEGER NOT NULL
);
  
  
  
  
  
  
  
  
